/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileAttributes;
import org.apache.commons.vfs2.provider.hdfs.HdfsFileSystem;
import org.apache.commons.vfs2.provider.hdfs.HdfsRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsFileObject
extends AbstractFileObject<HdfsFileSystem> {
    private final HdfsFileSystem fs;
    private final FileSystem hdfs;
    private final Path path;
    private FileStatus stat;

    protected HdfsFileObject(AbstractFileName name, HdfsFileSystem fs, FileSystem hdfs, Path path) {
        super(name, (AbstractFileSystem)fs);
        this.fs = fs;
        this.hdfs = hdfs;
        this.path = path;
    }

    public boolean canRenameTo(FileObject newfile) {
        if (!super.canRenameTo(newfile)) {
            return false;
        }
        try {
            return this.hdfs.getFileStatus(new Path(newfile.getName().getPath())) == null;
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void doAttach() throws Exception {
        try {
            this.stat = this.hdfs.getFileStatus(this.path);
        }
        catch (FileNotFoundException e) {
            this.stat = null;
        }
    }

    protected void doCreateFolder() throws Exception {
        this.hdfs.mkdirs(this.path);
    }

    protected void doDelete() throws Exception {
        this.hdfs.delete(this.path, true);
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        if (null == this.stat) {
            return super.doGetAttributes();
        }
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put(HdfsFileAttributes.LAST_ACCESS_TIME.toString(), this.stat.getAccessTime());
        attrs.put(HdfsFileAttributes.BLOCK_SIZE.toString(), this.stat.getBlockSize());
        attrs.put(HdfsFileAttributes.GROUP.toString(), this.stat.getGroup());
        attrs.put(HdfsFileAttributes.OWNER.toString(), this.stat.getOwner());
        attrs.put(HdfsFileAttributes.PERMISSIONS.toString(), this.stat.getPermission().toString());
        attrs.put(HdfsFileAttributes.LENGTH.toString(), this.stat.getLen());
        attrs.put(HdfsFileAttributes.MODIFICATION_TIME.toString(), this.stat.getModificationTime());
        return attrs;
    }

    protected long doGetContentSize() throws Exception {
        return this.stat.getLen();
    }

    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return this.hdfs.open(this.path, bufferSize);
    }

    protected long doGetLastModifiedTime() throws Exception {
        this.doAttach();
        if (null != this.stat) {
            return this.stat.getModificationTime();
        }
        return -1L;
    }

    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        if (append) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", (Object)this.path.getName());
        }
        return this.hdfs.create(this.path);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        if (mode.equals((Object)RandomAccessMode.READWRITE)) {
            throw new UnsupportedOperationException();
        }
        return new HdfsRandomAccessContent(this.path, this.hdfs);
    }

    protected FileType doGetType() throws Exception {
        try {
            this.doAttach();
            if (null == this.stat) {
                return FileType.IMAGINARY;
            }
            if (this.stat.isDirectory()) {
                return FileType.FOLDER;
            }
            return FileType.FILE;
        }
        catch (FileNotFoundException fnfe) {
            return FileType.IMAGINARY;
        }
    }

    protected boolean doIsHidden() throws Exception {
        return false;
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected String[] doListChildren() throws Exception {
        if (this.doGetType() != FileType.FOLDER) {
            throw new FileNotFolderException((Object)this);
        }
        FileStatus[] fileStatuses = this.hdfs.listStatus(this.path);
        return (String[])Stream.of(fileStatuses).filter(Objects::nonNull).map(status -> status.getPath().getName()).toArray(String[]::new);
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        if (this.doGetType() != FileType.FOLDER) {
            return null;
        }
        String[] children = this.doListChildren();
        FileObject[] fo = new FileObject[children.length];
        for (int i = 0; i < children.length; ++i) {
            Path p = new Path(this.path, children[i]);
            fo[i] = this.fs.resolveFile(p.toUri().toString());
        }
        return fo;
    }

    protected void doRemoveAttribute(String attrName) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected void doRename(FileObject newfile) throws Exception {
        this.hdfs.rename(this.path, new Path(newfile.getName().getPath()));
    }

    protected void doSetAttribute(String attrName, Object value) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected boolean doSetLastModifiedTime(long modtime) throws Exception {
        try {
            this.hdfs.setTimes(this.path, modtime, System.currentTimeMillis());
        }
        catch (IOException ioe) {
            throw new FileSystemException((Throwable)ioe);
        }
        return true;
    }

    public boolean exists() throws FileSystemException {
        try {
            this.doAttach();
            return this.stat != null;
        }
        catch (FileNotFoundException fne) {
            return false;
        }
        catch (Exception e) {
            throw new FileSystemException("Unable to check existence ", (Throwable)e);
        }
    }
}

