/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.common;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.Util;

public class ArrayOfBooleansSerDe
extends ArrayOfItemsSerDe<Boolean> {
    public static int computeBytesNeeded(int arrayLength) {
        return (arrayLength >>> 3) + ((arrayLength & 7) > 0 ? 1 : 0);
    }

    @Override
    public byte[] serializeToByteArray(Boolean item) {
        Objects.requireNonNull(item, "Item must not be null");
        byte[] bytes = new byte[]{item != false ? (byte)1 : 0};
        return bytes;
    }

    @Override
    public byte[] serializeToByteArray(Boolean[] items) {
        Objects.requireNonNull(items, "Items must not be null");
        int bytesNeeded = ArrayOfBooleansSerDe.computeBytesNeeded(items.length);
        byte[] bytes = new byte[bytesNeeded];
        MemorySegment seg = MemorySegment.ofArray(bytes);
        byte val = 0;
        for (int i = 0; i < items.length; ++i) {
            if (items[i].booleanValue()) {
                val = (byte)(val | 1 << (i & 7));
            }
            if ((i & 7) != 7) continue;
            seg.set(ValueLayout.JAVA_BYTE, (long)(i >>> 3), val);
            val = 0;
        }
        if ((items.length & 7) > 0) {
            seg.set(ValueLayout.JAVA_BYTE, (long)(bytesNeeded - 1), val);
        }
        return bytes;
    }

    public Boolean[] deserializeFromMemorySegment(MemorySegment seg, int numItems) {
        return this.deserializeFromMemorySegment(seg, 0L, numItems);
    }

    public Boolean[] deserializeFromMemorySegment(MemorySegment seg, long offsetBytes, int numItems) {
        Objects.requireNonNull(seg, "MemorySegment must not be null");
        if (numItems <= 0) {
            return new Boolean[0];
        }
        int numBytes = ArrayOfBooleansSerDe.computeBytesNeeded(numItems);
        Util.checkBounds(offsetBytes, numBytes, seg.byteSize());
        Boolean[] array = new Boolean[numItems];
        int srcVal = 0;
        int b = 0;
        for (int i = 0; i < numItems; ++i) {
            if ((i & 7) == 0) {
                srcVal = seg.get(ValueLayout.JAVA_BYTE, offsetBytes + (long)b++);
            }
            array[i] = (srcVal >>> (i & 7) & 1) == 1;
        }
        return array;
    }

    @Override
    public int sizeOf(Boolean item) {
        Objects.requireNonNull(item, "Item must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(1);
    }

    @Override
    public int sizeOf(Boolean[] items) {
        Objects.requireNonNull(items, "Item must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(items.length);
    }

    @Override
    public int sizeOf(MemorySegment seg, long offsetBytes, int numItems) {
        Objects.requireNonNull(seg, "MemorySegment must not be null");
        return ArrayOfBooleansSerDe.computeBytesNeeded(numItems);
    }

    @Override
    public String toString(Boolean item) {
        if (item == null) {
            return "null";
        }
        return item != false ? "true" : "false";
    }

    @Override
    public Class<Boolean> getClassOfT() {
        return Boolean.class;
    }
}

