/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Arrays;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.MemorySegmentStatus;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.quantiles.ClassicUtil;
import org.apache.datasketches.quantiles.CompactQuantilesDoublesSketch;
import org.apache.datasketches.quantiles.DirectUpdateDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketchAccessor;
import org.apache.datasketches.quantiles.DoublesUtil;
import org.apache.datasketches.quantiles.PreambleUtil;
import org.apache.datasketches.quantiles.UpdatableQuantilesDoublesSketch;

final class DirectCompactDoublesSketch
extends CompactQuantilesDoublesSketch {
    private static final int MIN_DIRECT_DOUBLES_SER_VER = 3;
    private final MemorySegment seg_;

    private DirectCompactDoublesSketch(int k, MemorySegment seg) {
        super(k);
        this.seg_ = seg.asReadOnly();
    }

    static DirectCompactDoublesSketch createFromUpdateSketch(UpdatableQuantilesDoublesSketch sketch, MemorySegment dstSeg) {
        long segCap = dstSeg.byteSize();
        int k = sketch.getK();
        long n = sketch.getN();
        DirectCompactDoublesSketch.checkDirectSegCapacity(k, n, segCap);
        dstSeg.set(ValueLayout.JAVA_LONG_UNALIGNED, 0L, 0L);
        PreambleUtil.insertPreLongs(dstSeg, 2);
        PreambleUtil.insertSerVer(dstSeg, 3);
        PreambleUtil.insertFamilyID(dstSeg, Family.QUANTILES.getID());
        PreambleUtil.insertK(dstSeg, k);
        int flags = 10;
        if (sketch.isEmpty()) {
            PreambleUtil.insertFlags(dstSeg, 14);
        } else {
            PreambleUtil.insertFlags(dstSeg, 10);
            PreambleUtil.insertN(dstSeg, n);
            PreambleUtil.insertMinDouble(dstSeg, sketch.getMinItem());
            PreambleUtil.insertMaxDouble(dstSeg, sketch.getMaxItem());
            int bbCount = ClassicUtil.computeBaseBufferItems(k, n);
            DoublesSketchAccessor inputAccessor = DoublesSketchAccessor.wrap(sketch, false);
            assert (bbCount == inputAccessor.numItems());
            long dstSegOffset = 32L;
            double[] bbArray = inputAccessor.getArray(0, bbCount);
            Arrays.sort(bbArray);
            MemorySegment.copy(bbArray, 0, dstSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, dstSegOffset, bbCount);
            dstSegOffset += (long)(bbCount << 3);
            int lvl = 0;
            for (long bitPattern = ClassicUtil.computeBitPattern(k, n); bitPattern > 0L; bitPattern >>>= 1) {
                if ((bitPattern & 1L) > 0L) {
                    inputAccessor.setLevel(lvl);
                    MemorySegment.copy(inputAccessor.getArray(0, k), 0, dstSeg, ValueLayout.JAVA_DOUBLE_UNALIGNED, dstSegOffset, k);
                    dstSegOffset += (long)(k << 3);
                }
                ++lvl;
            }
        }
        return new DirectCompactDoublesSketch(k, dstSeg);
    }

    static DirectCompactDoublesSketch wrapInstance(MemorySegment srcSeg) {
        long segCap = srcSeg.byteSize();
        int preLongs = PreambleUtil.extractPreLongs(srcSeg);
        int serVer = PreambleUtil.extractSerVer(srcSeg);
        int familyID = PreambleUtil.extractFamilyID(srcSeg);
        int flags = PreambleUtil.extractFlags(srcSeg);
        int k = PreambleUtil.extractK(srcSeg);
        boolean empty = (flags & 4) > 0;
        long n = empty ? 0L : PreambleUtil.extractN(srcSeg);
        DirectUpdateDoublesSketch.checkPreLongs(preLongs);
        ClassicUtil.checkFamilyID(familyID);
        DoublesUtil.checkDoublesSerVer(serVer, 3);
        DirectCompactDoublesSketch.checkCompact(serVer, flags);
        ClassicUtil.checkK(k);
        DirectCompactDoublesSketch.checkDirectSegCapacity(k, n, segCap);
        DirectUpdateDoublesSketch.checkEmptyAndN(empty, n);
        return new DirectCompactDoublesSketch(k, srcSeg);
    }

    @Override
    public double getMaxItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 24L);
    }

    @Override
    public double getMinItem() {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.seg_.get(ValueLayout.JAVA_DOUBLE_UNALIGNED, 16L);
    }

    @Override
    public long getN() {
        return this.seg_.byteSize() < 32L ? 0L : this.seg_.get(ValueLayout.JAVA_LONG_UNALIGNED, 8L);
    }

    @Override
    public boolean hasMemorySegment() {
        return this.seg_ != null;
    }

    @Override
    public boolean isOffHeap() {
        return this.seg_ != null ? this.seg_.isNative() : false;
    }

    @Override
    public boolean isSameResource(MemorySegment that) {
        return MemorySegmentStatus.isSameResource(this.seg_, that);
    }

    @Override
    int getBaseBufferCount() {
        return ClassicUtil.computeBaseBufferItems(this.getK(), this.getN());
    }

    @Override
    int getCombinedBufferItemCapacity() {
        return ((int)this.seg_.byteSize() - 32) / 8;
    }

    @Override
    double[] getCombinedBuffer() {
        int k = this.getK();
        if (this.isEmpty()) {
            return new double[k << 1];
        }
        long n = this.getN();
        int itemCap = ClassicUtil.computeRetainedItems(k, n);
        double[] combinedBuffer = new double[itemCap];
        MemorySegment.copy(this.seg_, ValueLayout.JAVA_DOUBLE_UNALIGNED, 32L, combinedBuffer, 0, itemCap);
        return combinedBuffer;
    }

    @Override
    long getBitPattern() {
        int k = this.getK();
        long n = this.getN();
        return ClassicUtil.computeBitPattern(k, n);
    }

    @Override
    MemorySegment getMemorySegment() {
        return this.seg_;
    }

    static void checkDirectSegCapacity(int k, long n, long segCapBytes) {
        int reqBufBytes = DirectCompactDoublesSketch.getCompactSerialiedSizeBytes(k, n);
        if (segCapBytes < (long)reqBufBytes) {
            throw new SketchesArgumentException("Possible corruption: MemorySegment capacity too small: " + segCapBytes + " < " + reqBufBytes);
        }
    }

    static void checkCompact(int serVer, int flags) {
        int compactFlagMask = 24;
        if (serVer != 2 && (flags & 4) == 0 && (flags & 0x18) != 24) {
            throw new SketchesArgumentException("Possible corruption: Must be v2, empty, or compact and ordered. Flags field: " + Integer.toBinaryString(flags) + ", SerVer: " + serVer);
        }
    }
}

