/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.cpc;

import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.pig.cpc.DataToSketchTest;
import org.apache.datasketches.pig.cpc.UnionSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();

    @Test
    public void execNullInputTuple() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execNormalCase() throws Exception {
        UnionSketch func = new UnionSketch();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update(1L);
        inputSketch.update(2L);
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void execNormalCaseCustomLgKAndSeed() throws Exception {
        UnionSketch func = new UnionSketch("10", "123");
        CpcSketch inputSketch = new CpcSketch(10, 123L);
        inputSketch.update(1L);
        inputSketch.update(2L);
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch(result, 123L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    @Test
    public void accumulator() throws Exception {
        UnionSketch func = new UnionSketch();
        DataByteArray result = (DataByteArray)func.getValue();
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update(1L);
        inputSketch.update(2L);
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        func.cleanup();
        result = (DataByteArray)func.getValue();
        sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getInitial()).newInstance();
        Tuple input = TUPLE_FACTORY.newTuple();
        Tuple result = (Tuple)func.exec(input);
        Assert.assertEquals((Iterable)result, (Iterable)input);
    }

    @Test
    public void algebraicIntermediateNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update(1L);
        inputSketch.update(2L);
        inputSketch.update(3L);
        DataBag outerBag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        outerBag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)outerBag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicIntermediateFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0));
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }

    @Test
    public void algebraicIntermediateFromIntermediateCustomLgKAndSeed() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getIntermed()).getConstructor(String.class, String.class).newInstance("10", "123");
        CpcSketch inputSketch = new CpcSketch(10, 123L);
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        Tuple result = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch((DataByteArray)result.get(0), 123L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    @Test
    public void algebraicFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(null);
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple());
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicFinalFromInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update(1L);
        inputSketch.update(2L);
        inputSketch.update(3L);
        DataBag outerBag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        outerBag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)outerBag));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
    }

    @Test
    public void algebraicFinalFromInitialCustomLgKAndSeed() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).getConstructor(String.class, String.class).newInstance("10", "123");
        CpcSketch inputSketch = new CpcSketch(10, 123L);
        inputSketch.update(1L);
        inputSketch.update(2L);
        inputSketch.update(3L);
        DataBag outerBag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        outerBag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)outerBag));
        CpcSketch sketch = DataToSketchTest.getSketch(result, 123L);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)3.0, (double)0.01);
        Assert.assertEquals((int)sketch.getLgK(), (int)10);
    }

    @Test
    public void algebraicFinalFromIntermediate() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionSketch().getFinal()).newInstance();
        CpcSketch inputSketch = new CpcSketch();
        inputSketch.update("a");
        inputSketch.update("b");
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray())));
        DataByteArray result = (DataByteArray)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        CpcSketch sketch = DataToSketchTest.getSketch(result);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((double)sketch.getEstimate(), (double)2.0, (double)0.01);
    }
}

