/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.GetPmf;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetPmfTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetPmf func = new GetPmf();
        KllFloatsSketch sketch = new KllFloatsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), Float.valueOf(0.0f))));
        Assert.assertNull((Object)resultTuple);
    }

    @Test
    public void normalCase() throws Exception {
        GetPmf func = new GetPmf();
        KllFloatsSketch sketch = new KllFloatsSketch();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((float)i);
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), Float.valueOf(2.0f), Float.valueOf(7.0f))));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)0.1);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)0.5);
        Assert.assertEquals((double)((Double)resultTuple.get(2)), (double)0.4);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetPmf func = new GetPmf();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetPmf func = new GetPmf();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeOfSplitPoint() throws Exception {
        GetPmf func = new GetPmf();
        KllFloatsSketch sketch = new KllFloatsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 1)));
    }
}

