/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.kll;

import java.util.Arrays;
import org.apache.datasketches.kll.KllFloatsSketch;
import org.apache.datasketches.pig.kll.GetQuantiles;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((float)((Float)resultTuple.get(0)).floatValue(), (float)Float.NaN);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooFewInputs() throws Exception {
        GetQuantiles func = new GetQuantiles();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantiles func = new GetQuantiles();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFractionOrNumberOfIntervals() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), "")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeAmongFractions() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0, 1)));
    }

    @Test
    public void oneFraction() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((float)i);
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((float)((Float)resultTuple.get(0)).floatValue(), (float)6.0f);
    }

    @Test
    public void severalFractions() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((float)i);
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0, 0.5, 1.0)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((float)((Float)resultTuple.get(0)).floatValue(), (float)1.0f);
        Assert.assertEquals((float)((Float)resultTuple.get(1)).floatValue(), (float)6.0f);
        Assert.assertEquals((float)((Float)resultTuple.get(2)).floatValue(), (float)10.0f);
    }

    @Test
    public void numberOfEvenlySpacedIntervals() throws Exception {
        GetQuantiles func = new GetQuantiles();
        KllFloatsSketch sketch = new KllFloatsSketch();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((float)i);
        }
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 3)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((float)((Float)resultTuple.get(0)).floatValue(), (float)1.0f);
        Assert.assertEquals((float)((Float)resultTuple.get(1)).floatValue(), (float)6.0f);
        Assert.assertEquals((float)((Float)resultTuple.get(2)).floatValue(), (float)10.0f);
    }
}

