/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import org.apache.datasketches.pig.quantiles.GetKFromDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetKFromDoublesSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();

    @Test
    public void defalutK() throws Exception {
        GetKFromDoublesSketch func = new GetKFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)128);
    }

    @Test
    public void customK() throws Exception {
        GetKFromDoublesSketch func = new GetKFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().setK(1024).build();
        Integer result = (Integer)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()))));
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)result, (Object)1024);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooFewInputs() throws Exception {
        GetKFromDoublesSketch func = new GetKFromDoublesSketch();
        func.exec(TUPLE_FACTORY.newTuple());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooManyInputs() throws Exception {
        GetKFromDoublesSketch func = new GetKFromDoublesSketch();
        func.exec(TUPLE_FACTORY.newTuple(2));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetKFromDoublesSketch func = new GetKFromDoublesSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0)));
    }
}

