/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.pig.quantiles.GetQuantileFromStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantileFromStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void emptySketch() throws Exception {
        GetQuantileFromStringsSketch func = new GetQuantileFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        String result = (String)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.0)));
        Assert.assertNull((Object)result);
    }

    @Test
    public void normalCase() throws Exception {
        GetQuantileFromStringsSketch func = new GetQuantileFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        sketch.update((Object)"a");
        String result = (String)func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 0.5)));
        Assert.assertEquals((String)result, (String)"a");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongNumberOfInputs() throws Exception {
        GetQuantileFromStringsSketch func = new GetQuantileFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantileFromStringsSketch func = new GetQuantileFromStringsSketch();
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFraction() throws Exception {
        GetQuantileFromStringsSketch func = new GetQuantileFromStringsSketch();
        ItemsSketch sketch = ItemsSketch.getInstance(COMPARATOR);
        func.exec(TUPLE_FACTORY.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray(SER_DE)), 1)));
    }
}

