/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Arrays;
import org.apache.datasketches.pig.quantiles.GetQuantilesFromDoublesSketch;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.datasketches.quantiles.UpdateDoublesSketch;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class GetQuantilesFromDoublesSketchTest {
    private static final TupleFactory tupleFactory = TupleFactory.getInstance();

    @Test
    public void emptySketch() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)Double.NaN);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void tooFewInputs() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        func.exec(tupleFactory.newTuple(1));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForSketch() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        func.exec(tupleFactory.newTuple(Arrays.asList(1.0, 1.0)));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeForFractionOrNumberOfIntervals() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), "")));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void wrongTypeAmongFractions() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0, 1)));
    }

    @Test
    public void oneFraction() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((double)i);
        }
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.5)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)6.0);
    }

    @Test
    public void severalFractions() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((double)i);
        }
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 0.0, 0.5, 1.0)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)6.0);
        Assert.assertEquals((double)((Double)resultTuple.get(2)), (double)10.0);
    }

    @Test
    public void numberOfEvenlySpacedIntervals() throws Exception {
        GetQuantilesFromDoublesSketch func = new GetQuantilesFromDoublesSketch();
        UpdateDoublesSketch sketch = DoublesSketch.builder().build();
        for (int i = 1; i <= 10; ++i) {
            sketch.update((double)i);
        }
        Tuple resultTuple = (Tuple)func.exec(tupleFactory.newTuple(Arrays.asList(new DataByteArray(sketch.toByteArray()), 3)));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)3);
        Assert.assertEquals((double)((Double)resultTuple.get(0)), (double)1.0);
        Assert.assertEquals((double)((Double)resultTuple.get(1)), (double)6.0);
        Assert.assertEquals((double)((Double)resultTuple.get(2)), (double)10.0);
    }
}

