/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.quantiles;

import java.util.Comparator;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.ArrayOfStringsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.quantiles.UnionStringsSketch;
import org.apache.datasketches.quantiles.ItemsSketch;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class UnionStringsSketchTest {
    private static final TupleFactory TUPLE_FACTORY = TupleFactory.getInstance();
    private static final BagFactory BAG_FACTORY = BagFactory.getInstance();
    private static final Comparator<String> COMPARATOR = Comparator.naturalOrder();
    private static final ArrayOfItemsSerDe<String> SER_DE = new ArrayOfStringsSerDe();

    @Test
    public void execNullInputTuple() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(null);
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyInputTuple() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execEmptyBag() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void execNormalCase() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        ItemsSketch inputSketch = ItemsSketch.getInstance(COMPARATOR);
        inputSketch.update((Object)"a");
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray(SER_DE))));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)1L);
    }

    @Test
    public void accumulator() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        Tuple resultTuple = (Tuple)func.getValue();
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(null);
        resultTuple = (Tuple)func.getValue();
        sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple());
        resultTuple = (Tuple)func.getValue();
        sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        func.accumulate(TUPLE_FACTORY.newTuple((Object)BAG_FACTORY.newDefaultBag()));
        resultTuple = (Tuple)func.getValue();
        sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
        DataBag bag = BAG_FACTORY.newDefaultBag();
        ItemsSketch inputSketch = ItemsSketch.getInstance(COMPARATOR);
        inputSketch.update((Object)"a");
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(inputSketch.toByteArray(SER_DE))));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        func.accumulate(TUPLE_FACTORY.newTuple((Object)bag));
        resultTuple = (Tuple)func.getValue();
        sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
        func.cleanup();
        resultTuple = (Tuple)func.getValue();
        sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicInitial() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionStringsSketch().getInitial()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple());
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Assert.assertTrue((boolean)(resultTuple.get(0) instanceof DataBag));
        Assert.assertEquals((long)((DataBag)resultTuple.get(0)).size(), (long)1L);
    }

    @Test
    public void algebraicIntermediateIsSameAsFinal() {
        Assert.assertEquals((String)new UnionStringsSketch().getIntermed(), (String)new UnionStringsSketch().getFinal());
    }

    @Test
    public void algebraicIntermediateFinalNullInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionStringsSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(null);
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalEmptyInputTuple() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionStringsSketch().getIntermed()).newInstance();
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple());
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertTrue((boolean)sketch.isEmpty());
    }

    @Test
    public void algebraicIntermediateFinalNormalCase() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionStringsSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        DataBag innerBag = BAG_FACTORY.newDefaultBag();
        ItemsSketch qs = ItemsSketch.getInstance(COMPARATOR);
        qs.update((Object)"a");
        innerBag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs.toByteArray(SER_DE))));
        bag.add(TUPLE_FACTORY.newTuple((Object)innerBag));
        ItemsSketch qs2 = ItemsSketch.getInstance(COMPARATOR);
        qs2.update((Object)"b");
        bag.add(TUPLE_FACTORY.newTuple((Object)new DataByteArray(qs2.toByteArray(SER_DE))));
        Tuple resultTuple = (Tuple)func.exec(TUPLE_FACTORY.newTuple((Object)bag));
        ItemsSketch<String> sketch = UnionStringsSketchTest.getSketch(resultTuple);
        Assert.assertFalse((boolean)sketch.isEmpty());
        Assert.assertEquals((long)sketch.getN(), (long)2L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void algebraicIntermediateFinalWrongType() throws Exception {
        EvalFunc func = (EvalFunc)Class.forName(new UnionStringsSketch().getIntermed()).newInstance();
        DataBag bag = BAG_FACTORY.newDefaultBag();
        bag.add(TUPLE_FACTORY.newTuple((Object)1.0));
        func.exec(TUPLE_FACTORY.newTuple((Object)bag));
    }

    @Test
    public void schema() throws Exception {
        UnionStringsSketch func = new UnionStringsSketch();
        Schema schema = func.outputSchema(new Schema());
        Assert.assertNotNull((Object)schema);
        Assert.assertEquals((int)schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).type, (byte)110);
        Assert.assertEquals((int)schema.getField((int)0).schema.size(), (int)1);
        Assert.assertEquals((byte)schema.getField((int)0).schema.getField((int)0).type, (byte)50);
    }

    private static ItemsSketch<String> getSketch(Tuple tuple) throws Exception {
        Assert.assertNotNull((Object)tuple);
        Assert.assertEquals((int)tuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)tuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        return ItemsSketch.getInstance((Memory)Memory.wrap((byte[])bytes.get()), COMPARATOR, SER_DE);
    }
}

