/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.sampling;

import java.io.IOException;
import java.util.HashMap;
import org.apache.datasketches.ArrayOfItemsSerDe;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.pig.sampling.ArrayOfTuplesSerDe;
import org.apache.datasketches.pig.sampling.VarOptCommonImpl;
import org.apache.datasketches.sampling.VarOptItemsSamples;
import org.apache.datasketches.sampling.VarOptItemsSketch;
import org.apache.datasketches.sampling.VarOptItemsUnion;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

public class VarOptCommonAlgebraicTest {
    private static final ArrayOfTuplesSerDe serDe_ = new ArrayOfTuplesSerDe();

    @Test
    public void rawTuplesToSketchConstructors() {
        VarOptCommonImpl.RawTuplesToSketchTuple udf = new VarOptCommonImpl.RawTuplesToSketchTuple();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.RawTuplesToSketchTuple("5");
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.RawTuplesToSketchTuple("5", "3");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptCommonImpl.RawTuplesToSketchTuple("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.RawTuplesToSketchTuple("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.RawTuplesToSketchTuple("10", "-1");
            Assert.fail((String)"Accepted negative weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void unionSketchesAsSketchConstructors() {
        VarOptCommonImpl.UnionSketchesAsTuple udf = new VarOptCommonImpl.UnionSketchesAsTuple();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.UnionSketchesAsTuple("5");
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.UnionSketchesAsTuple("5", "3");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptCommonImpl.UnionSketchesAsTuple("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.UnionSketchesAsTuple("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.UnionSketchesAsTuple("10", "-1");
            Assert.fail((String)"Accepted negative weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void unionSketchesAsByteArrayConstructors() {
        VarOptCommonImpl.UnionSketchesAsByteArray udf = new VarOptCommonImpl.UnionSketchesAsByteArray();
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.UnionSketchesAsByteArray("5");
        Assert.assertNotNull((Object)udf);
        udf = new VarOptCommonImpl.UnionSketchesAsByteArray("5", "3");
        Assert.assertNotNull((Object)udf);
        try {
            new VarOptCommonImpl.UnionSketchesAsByteArray("-1");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.UnionSketchesAsByteArray("-1", "3");
            Assert.fail((String)"Accepted negative k");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new VarOptCommonImpl.UnionSketchesAsByteArray("10", "-1");
            Assert.fail((String)"Accepted negative weight index");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void rawTuplesToSketchTupleExec() {
        int k = 5;
        boolean wtIdx = true;
        VarOptCommonImpl.RawTuplesToSketchTuple udf = new VarOptCommonImpl.RawTuplesToSketchTuple(Integer.toString(5), Integer.toString(1));
        char id = 'a';
        double wt = 1.0;
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        try {
            for (int i = 0; i < 6; ++i) {
                Tuple t = TupleFactory.getInstance().newTuple(2);
                t.set(0, (Object)Character.toString(id));
                t.set(1, (Object)wt);
                inputBag.add(t);
                id = (char)(id + '\u0001');
                wt += 1.0;
            }
        }
        catch (ExecException e) {
            Assert.fail((String)"Unexpected ExecException creating input data");
        }
        try {
            Tuple result = udf.exec(null);
            Assert.assertNull((Object)result);
            Tuple inputTuple = TupleFactory.getInstance().newTuple(0);
            result = udf.exec(inputTuple);
            Assert.assertNull((Object)result);
            inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, null);
            result = udf.exec(inputTuple);
            Assert.assertNull((Object)result);
            inputTuple.set(0, (Object)inputBag);
            result = udf.exec(inputTuple);
            Assert.assertEquals((int)result.size(), (int)1);
            DataByteArray dba = (DataByteArray)result.get(0);
            VarOptItemsSketch vis = VarOptItemsSketch.heapify((Memory)Memory.wrap((byte[])dba.get()), (ArrayOfItemsSerDe)serDe_);
            Assert.assertEquals((long)vis.getN(), (long)6L);
            Assert.assertEquals((int)vis.getK(), (int)5);
            for (VarOptItemsSamples.WeightedSample ws : vis.getSketchSamples()) {
                Tuple t = (Tuple)ws.getItem();
                Assert.assertTrue(((Double)t.get(1) >= 1.0 ? 1 : 0) != 0);
                Assert.assertTrue(((Double)t.get(1) <= 6.0 ? 1 : 0) != 0);
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException calling exec()");
        }
    }

    @Test
    public void unionSketchesDegenerateInput() {
        try {
            VarOptCommonImpl.UnionSketchesAsTuple udfTuple = new VarOptCommonImpl.UnionSketchesAsTuple("4");
            Tuple result = udfTuple.exec(null);
            Assert.assertNull((Object)result);
            Tuple inputTuple = TupleFactory.getInstance().newTuple(0);
            result = udfTuple.exec(inputTuple);
            Assert.assertNull((Object)result);
            inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, null);
            result = udfTuple.exec(inputTuple);
            Assert.assertNull((Object)result);
            VarOptCommonImpl.UnionSketchesAsByteArray udfBA = new VarOptCommonImpl.UnionSketchesAsByteArray("4");
            DataByteArray output = udfBA.exec(null);
            Assert.assertNull((Object)output);
            inputTuple = TupleFactory.getInstance().newTuple(0);
            output = udfBA.exec(inputTuple);
            Assert.assertNull((Object)output);
            inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, null);
            output = udfBA.exec(inputTuple);
            Assert.assertNull((Object)output);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException calling exec()");
        }
    }

    @Test
    public void unionSketchesExec() {
        int numSketches = 3;
        int numItemsPerSketch = 10;
        int k = 100;
        String kStr = Integer.toString(100);
        VarOptCommonImpl.UnionSketchesAsTuple udfTuple = new VarOptCommonImpl.UnionSketchesAsTuple(kStr);
        VarOptCommonImpl.UnionSketchesAsByteArray udfBA = new VarOptCommonImpl.UnionSketchesAsByteArray(kStr);
        char id = 'a';
        double wt = 1.0;
        DataBag inputBag = BagFactory.getInstance().newDefaultBag();
        VarOptItemsUnion union = VarOptItemsUnion.newInstance((int)100);
        VarOptItemsSketch vis = VarOptItemsSketch.newInstance((int)100);
        try {
            for (int j = 0; j < 3; ++j) {
                vis.reset();
                for (int i = 0; i < 10; ++i) {
                    Tuple t = TupleFactory.getInstance().newTuple(2);
                    t.set(0, (Object)Character.toString(id));
                    t.set(1, (Object)wt);
                    vis.update((Object)t, wt);
                    id = (char)(id + '\u0001');
                    wt += 1.0;
                }
                Tuple wrapper = TupleFactory.getInstance().newTuple(1);
                wrapper.set(0, (Object)new DataByteArray(vis.toByteArray((ArrayOfItemsSerDe)serDe_)));
                inputBag.add(wrapper);
                union.update(vis);
            }
        }
        catch (ExecException e) {
            Assert.fail((String)"Unexpected ExecException creating input data");
        }
        try {
            Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
            inputTuple.set(0, (Object)inputBag);
            DataByteArray outArray = udfBA.exec(inputTuple);
            VarOptItemsSketch sketch1 = VarOptItemsSketch.heapify((Memory)Memory.wrap((byte[])outArray.get()), (ArrayOfItemsSerDe)serDe_);
            Tuple outTuple = udfTuple.exec(inputTuple);
            DataByteArray dba = (DataByteArray)outTuple.get(0);
            VarOptItemsSketch sketch2 = VarOptItemsSketch.heapify((Memory)Memory.wrap((byte[])dba.get()), (ArrayOfItemsSerDe)serDe_);
            VarOptItemsSketch expectedResult = union.getResult();
            VarOptCommonAlgebraicTest.compareResults((VarOptItemsSketch<Tuple>)sketch1, (VarOptItemsSketch<Tuple>)expectedResult);
            VarOptCommonAlgebraicTest.compareResults((VarOptItemsSketch<Tuple>)sketch2, (VarOptItemsSketch<Tuple>)expectedResult);
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected IOException calling exec()");
        }
    }

    static void compareResults(VarOptItemsSketch<Tuple> s1, VarOptItemsSketch<Tuple> s2) {
        Assert.assertEquals((long)s1.getN(), (long)s2.getN());
        Assert.assertEquals((int)s1.getK(), (int)s2.getK());
        HashMap<Object, Double> items = new HashMap<Object, Double>(s1.getNumSamples());
        for (VarOptItemsSamples.WeightedSample ws : s1.getSketchSamples()) {
            items.put(ws.getItem(), ws.getWeight());
        }
        for (VarOptItemsSamples.WeightedSample ws : s2.getSketchSamples()) {
            Assert.assertEquals((double)((Double)items.get(ws.getItem())), (double)ws.getWeight());
        }
    }
}

