/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.pig.theta;

import java.io.IOException;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.pig.PigTestingUtil;
import org.apache.datasketches.pig.theta.Estimate;
import org.apache.datasketches.pig.theta.Intersect;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.DataType;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.testng.Assert;
import org.testng.annotations.Test;

public class IntersectTest {
    @Test(expectedExceptions={IllegalStateException.class})
    public void checkGetValueExcep() {
        Intersect inter = new Intersect();
        inter.getValue();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkNotDBAExcep() throws IOException {
        Intersect inter = new Intersect();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        inter.accumulate(inputTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        inter = new Intersect();
        inter.accumulate(inputTuple);
    }

    @Test
    public void checkConstructors() {
        Intersect inter = new Intersect();
        inter = new Intersect(9001L);
        Intersect.Initial initial = new Intersect.Initial();
        initial = new Intersect.Initial("9001");
        Intersect.IntermediateFinal interFin = new Intersect.IntermediateFinal();
        interFin = new Intersect.IntermediateFinal("9001");
        interFin = new Intersect.IntermediateFinal(9001L);
        Assert.assertNotNull((Object)initial);
        Assert.assertNotNull((Object)interFin);
        inter.cleanup();
    }

    @Test
    public void checkNullInput() throws IOException {
        Intersect interFunc = new Intersect();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)0.0, (double)0.0);
    }

    @Test
    public void checkExactTopExec() throws IOException {
        Intersect interFunc = new Intersect();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, i * 64, 256));
            bag.add(dataTuple);
        }
        Tuple resultTuple = (Tuple)interFunc.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)64.0, (double)0.0);
    }

    @Test(expectedExceptions={ClassCastException.class})
    public void checkBadClassCast() throws IOException {
        Intersect interFunc = new Intersect();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        inputTuple.set(0, (Object)new Double(1.0));
        interFunc.accumulate(inputTuple);
    }

    @Test
    public void checkNullEmptyAccumulator() throws IOException {
        Intersect interFunc = new Intersect();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = null;
        interFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(0);
        interFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        interFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        interFunc.accumulate(inputTuple);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(0);
        bag.add(innerTuple);
        interFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        interFunc.accumulate(inputTuple);
        inputTuple = TupleFactory.getInstance().newTuple(1);
        bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
        dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, 0, 64));
        bag.add(dataTuple);
        interFunc.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)interFunc.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)64.0, (double)0.0);
    }

    @Test
    public void checkExactAccumulator() throws IOException {
        Intersect interFunc = new Intersect();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, i * 64, 256));
            bag.add(dataTuple);
        }
        interFunc.accumulate(inputTuple);
        Tuple resultTuple = (Tuple)interFunc.getValue();
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray dba = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((dba.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)64.0, (double)0.0);
    }

    @Test
    public void checkExactAlgebraicInitial() throws IOException {
        Intersect.Initial interFuncInit = new Intersect.Initial();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple dataTuple = TupleFactory.getInstance().newTuple(1);
            dataTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(16, i, 1));
            bag.add(dataTuple);
        }
        Tuple resultTuple = (Tuple)interFuncInit.exec(inputTuple);
        Assert.assertTrue((resultTuple == inputTuple ? 1 : 0) != 0);
    }

    @Test
    public void checkAlgFinalFromPriorIntermed() throws IOException {
        Intersect.IntermediateFinal interFuncIFinal = new Intersect.IntermediateFinal();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        for (int i = 0; i < 4; ++i) {
            Tuple sketchTuple = TupleFactory.getInstance().newTuple(1);
            sketchTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, i * 64, 256));
            bag.add(sketchTuple);
        }
        Tuple resultTuple = (Tuple)interFuncIFinal.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)64.0, (double)0.0);
    }

    @Test
    public void checkAlgFinalFromPriorInitial() throws IOException {
        Intersect.IntermediateFinal interFuncFinal = new Intersect.IntermediateFinal();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        DataBag innerBag = BagFactory.getInstance().newDefaultBag();
        innerTuple.set(0, (Object)innerBag);
        bag.add(innerTuple);
        for (int i = 0; i < 4; ++i) {
            Tuple sketchTuple = TupleFactory.getInstance().newTuple(1);
            sketchTuple.set(0, (Object)PigTestingUtil.createDbaFromQssRange(256, i * 64, 256));
            innerBag.add(sketchTuple);
        }
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertNotNull((Object)resultTuple);
        Assert.assertEquals((int)resultTuple.size(), (int)1);
        DataByteArray bytes = (DataByteArray)resultTuple.get(0);
        Assert.assertTrue((bytes.size() > 0 ? 1 : 0) != 0);
        Double est = (Double)estFunc.exec(resultTuple);
        Assert.assertEquals((double)est, (double)64.0, (double)0.0);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkAlgFinalOuterBagEmptyTuples() throws IOException {
        Intersect.IntermediateFinal interFuncFinal = new Intersect.IntermediateFinal();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
    }

    @Test(expectedExceptions={SketchesStateException.class})
    public void checkAlgFinalInnerBagEmpty() throws IOException {
        Intersect.IntermediateFinal interFuncFinal = new Intersect.IntermediateFinal();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        DataBag bag2 = BagFactory.getInstance().newDefaultBag();
        innerTuple.set(0, (Object)bag2);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void checkAlgFinalInnerNotDBA() throws IOException {
        Intersect.IntermediateFinal interFuncFinal = new Intersect.IntermediateFinal();
        Estimate estFunc = new Estimate();
        Tuple inputTuple = TupleFactory.getInstance().newTuple(1);
        Tuple resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        DataBag bag = BagFactory.getInstance().newDefaultBag();
        inputTuple.set(0, (Object)bag);
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
        Tuple innerTuple = TupleFactory.getInstance().newTuple(1);
        bag.add(innerTuple);
        innerTuple.set(0, (Object)new Double(1.0));
        resultTuple = (Tuple)interFuncFinal.exec(inputTuple);
        Assert.assertEquals((double)((Double)estFunc.exec(resultTuple)), (double)0.0, (double)0.0);
    }

    @Test
    public void outputSchemaTest() throws IOException {
        Intersect udf = new Intersect();
        Schema inputSchema = null;
        Schema nullOutputSchema = null;
        Schema outputSchema = null;
        Schema.FieldSchema outputOuterFs0 = null;
        Schema outputInnerSchema = null;
        Schema.FieldSchema outputInnerFs0 = null;
        inputSchema = Schema.generateNestedSchema((byte)120, (byte[])new byte[]{50});
        nullOutputSchema = udf.outputSchema(null);
        outputSchema = udf.outputSchema(inputSchema);
        outputOuterFs0 = outputSchema.getField(0);
        outputInnerSchema = outputOuterFs0.schema;
        outputInnerFs0 = outputInnerSchema.getField(0);
        Assert.assertNull((Object)nullOutputSchema, (String)"Should be null");
        Assert.assertNotNull((Object)outputOuterFs0, (String)"outputSchema.getField(0) schema may not be null");
        String expected = "tuple";
        String result = DataType.findTypeName((byte)outputOuterFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        expected = "bytearray";
        Assert.assertNotNull((Object)outputInnerFs0, (String)"innerSchema.getField(0) schema may not be null");
        result = DataType.findTypeName((byte)outputInnerFs0.type);
        Assert.assertEquals((String)result, (String)expected);
        StringBuilder sb = new StringBuilder();
        sb.append("input schema: ").append(inputSchema).append(PigTestingUtil.LS).append("output schema: ").append(outputSchema).append(PigTestingUtil.LS).append("outputOuterFs: ").append(outputOuterFs0).append(", type: ").append(DataType.findTypeName((byte)outputOuterFs0.type)).append(PigTestingUtil.LS).append("outputInnerSchema: ").append(outputInnerSchema).append(PigTestingUtil.LS).append("outputInnerFs0: ").append(outputInnerFs0).append(", type: ").append(DataType.findTypeName((byte)outputInnerFs0.type)).append(PigTestingUtil.LS);
        IntersectTest.println(sb.toString());
    }

    @Test
    public void printlnTest() {
        IntersectTest.println(this.getClass().getSimpleName());
    }

    static void println(String s) {
    }
}

