/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Objects;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite.internal.tostring.IgniteToStringInclude;
import org.apache.ignite.internal.tostring.S;
import org.apache.ignite.raft.jraft.rpc.AppendEntriesResponseBuilder;
import org.apache.ignite.raft.jraft.rpc.RpcRequests;

public class AppendEntriesResponseImpl
implements RpcRequests.AppendEntriesResponse {
    public static final short GROUP_TYPE = 3;
    public static final short TYPE = 3009;
    @IgniteToStringInclude
    private final long lastLogIndex;
    @IgniteToStringInclude
    private final boolean success;
    @IgniteToStringInclude
    private final long term;
    @IgniteToStringInclude
    private HybridTimestamp timestamp;
    private byte[] timestampByteArray;

    private AppendEntriesResponseImpl(long lastLogIndex, boolean success, long term, HybridTimestamp timestamp, byte[] timestampByteArray) {
        this.lastLogIndex = lastLogIndex;
        this.success = success;
        this.term = term;
        this.timestamp = timestamp;
        this.timestampByteArray = timestampByteArray;
    }

    @Override
    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public long term() {
        return this.term;
    }

    byte[] timestampByteArray() {
        return this.timestampByteArray;
    }

    @Override
    public HybridTimestamp timestamp() {
        return this.timestamp;
    }

    public short groupType() {
        return 3;
    }

    public String toString() {
        return S.toString(AppendEntriesResponseImpl.class, (Object)this);
    }

    public short messageType() {
        return 3009;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AppendEntriesResponseImpl otherMessage = (AppendEntriesResponseImpl)other;
        return Objects.equals(this.timestamp, otherMessage.timestamp) && this.lastLogIndex == otherMessage.lastLogIndex && this.success == otherMessage.success && this.term == otherMessage.term;
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.lastLogIndex, this.success, this.term, this.timestamp);
        return result;
    }

    public static AppendEntriesResponseBuilder builder() {
        return new Builder();
    }

    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        MarshalledObject timestampByteArraymo = marshaller.marshal((Object)this.timestamp);
        usedDescriptors.addAll((IntCollection)timestampByteArraymo.usedDescriptorIds());
        this.timestampByteArray = timestampByteArraymo.bytes();
    }

    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        this.timestamp = (HybridTimestamp)marshaller.unmarshal(this.timestampByteArray, descriptorsObj);
        this.timestampByteArray = null;
    }

    private static class Builder
    implements AppendEntriesResponseBuilder {
        private long lastLogIndex;
        private boolean success;
        private long term;
        private HybridTimestamp timestamp;
        private byte[] timestampByteArray;

        private Builder() {
        }

        @Override
        public AppendEntriesResponseBuilder lastLogIndex(long lastLogIndex) {
            this.lastLogIndex = lastLogIndex;
            return this;
        }

        @Override
        public AppendEntriesResponseBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Override
        public AppendEntriesResponseBuilder term(long term) {
            this.term = term;
            return this;
        }

        @Override
        public AppendEntriesResponseBuilder timestamp(HybridTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public AppendEntriesResponseBuilder timestampByteArray(byte[] timestampByteArray) {
            this.timestampByteArray = timestampByteArray;
            return this;
        }

        @Override
        public long lastLogIndex() {
            return this.lastLogIndex;
        }

        @Override
        public boolean success() {
            return this.success;
        }

        @Override
        public long term() {
            return this.term;
        }

        @Override
        public HybridTimestamp timestamp() {
            return this.timestamp;
        }

        @Override
        public byte[] timestampByteArray() {
            return this.timestampByteArray;
        }

        @Override
        public RpcRequests.AppendEntriesResponse build() {
            return new AppendEntriesResponseImpl(this.lastLogIndex, this.success, this.term, this.timestamp, this.timestampByteArray);
        }
    }
}

