/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.node.metric;

import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.node.metric.NodeMetricEnableCallInput;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;
import org.apache.ignite.internal.cli.core.exception.IgniteCliApiException;
import org.apache.ignite.rest.client.api.NodeMetricApi;
import org.apache.ignite.rest.client.invoker.ApiException;
import org.apache.ignite.rest.client.invoker.Configuration;

@Singleton
public class NodeMetricEnableCall
implements Call<NodeMetricEnableCallInput, String> {
    @Override
    public CallOutput<String> execute(NodeMetricEnableCallInput input) {
        NodeMetricApi api = NodeMetricEnableCall.createApiClient(input);
        try {
            if (input.getEnable()) {
                api.enableNodeMetric(input.getSrcName());
            } else {
                api.disableNodeMetric(input.getSrcName());
            }
            String message = input.getEnable() ? "enabled" : "disabled";
            return DefaultCallOutput.success("Metric source was " + message + " successfully");
        }
        catch (IllegalArgumentException | ApiException e) {
            return DefaultCallOutput.failure(new IgniteCliApiException(e, input.getEndpointUrl()));
        }
    }

    private static NodeMetricApi createApiClient(NodeMetricEnableCallInput input) {
        return new NodeMetricApi(Configuration.getDefaultApiClient().setBasePath(input.getEndpointUrl()));
    }
}

