/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.repl.completer;

import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ignite.internal.cli.core.repl.completer.CompleterConf;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleter;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompleterFactory;
import org.apache.ignite.internal.cli.core.repl.completer.DynamicCompletionInsider;
import org.apache.ignite.internal.cli.util.ArrayUtils;
import org.jetbrains.annotations.Nullable;

@Singleton
public class DynamicCompleterRegistry {
    private final List<CompletionStrategy> completionStrategiesList = new ArrayList<CompletionStrategy>();
    private final DynamicCompletionInsider dynamicCompletionInsider = new DynamicCompletionInsider();

    public List<DynamicCompleter> findCompleters(String[] words) {
        return this.completionStrategiesList.stream().filter(strategy -> strategy.canBeApplied(words)).map(strategy -> strategy.completer(words)).collect(Collectors.toList());
    }

    public void register(CompleterConf conf, DynamicCompleterFactory factory) {
        if (conf.isExclusiveEnableOptions()) {
            this.completionStrategiesList.forEach(strategy -> strategy.exclusiveDisableOptions.addAll(conf.enableOptions()));
        }
        Set exclusiveDisableOptions = this.completionStrategiesList.stream().filter(strategy -> strategy.conf.isExclusiveEnableOptions()).flatMap(strategy -> strategy.conf.enableOptions().stream()).collect(Collectors.toSet());
        CompletionStrategy strategy2 = new CompletionStrategy(conf, factory);
        strategy2.exclusiveDisableOptions.addAll(exclusiveDisableOptions);
        this.completionStrategiesList.add(strategy2);
    }

    private class CompletionStrategy {
        private final CompleterConf conf;
        private final DynamicCompleterFactory factory;
        private final Set<String> exclusiveDisableOptions = new HashSet<String>();

        private CompletionStrategy(CompleterConf conf, DynamicCompleterFactory factory) {
            this.conf = conf;
            this.factory = factory;
        }

        private boolean samePrefix(String[] words, String[] prefixWords) {
            if (words.length < prefixWords.length) {
                return false;
            }
            for (int i = 0; i < prefixWords.length; ++i) {
                if (words[i].equals(prefixWords[i])) continue;
                return false;
            }
            return true;
        }

        boolean canBeApplied(String[] words) {
            boolean alreadyHasPositionalArgument;
            if (this.conf.isSinglePositionalParameter() && (alreadyHasPositionalArgument = DynamicCompleterRegistry.this.dynamicCompletionInsider.wasPositionalParameterCompleted(words))) {
                return false;
            }
            if (!this.conf.commandSpecific()) {
                return this.canBeAppliedCommandMatch(words);
            }
            Optional<String[]> commandsMatch = this.conf.commands().stream().filter(command -> this.samePrefix(words, (String[])command)).findFirst();
            return commandsMatch.isPresent() && this.canBeAppliedCommandMatch(words);
        }

        private boolean canBeAppliedCommandMatch(String[] words) {
            String cursorWord = words[words.length - 1];
            String lastNotEmptyWord = ArrayUtils.findLastNotEmptyWord(words);
            String preLastNotEmptyWord = ArrayUtils.findLastNotEmptyWordBeforeWordFromEnd(words, lastNotEmptyWord);
            if (this.shouldBeDisabled(preLastNotEmptyWord, lastNotEmptyWord, cursorWord)) {
                return false;
            }
            if (this.conf.hasEnableOptions()) {
                if (cursorWord.equals(lastNotEmptyWord)) {
                    return this.conf.enableOptions().contains(lastNotEmptyWord) || this.conf.enableOptions().contains(preLastNotEmptyWord);
                }
                return this.conf.enableOptions().contains(lastNotEmptyWord);
            }
            if (this.conf.hasDisableOptions()) {
                if (cursorWord.equals(lastNotEmptyWord)) {
                    return !this.conf.disableOptions().contains(lastNotEmptyWord) && !this.conf.disableOptions().contains(preLastNotEmptyWord);
                }
                return !this.conf.disableOptions().contains(lastNotEmptyWord);
            }
            return true;
        }

        DynamicCompleter completer(String[] words) {
            if (this.conf.hasFilter()) {
                return input -> {
                    List<String> candidates = this.factory.getDynamicCompleter(input).complete(input);
                    return List.of(this.conf.getFilter().filter(input, candidates.toArray(new String[0])));
                };
            }
            return this.factory.getDynamicCompleter(words);
        }

        private boolean shouldBeDisabled(String preLastNotEmptyWord, String lastNotEmptyWord, String cursorWord) {
            boolean enableOverridesDisable = this.intersect(this.conf.enableOptions(), this.exclusiveDisableOptions);
            if (enableOverridesDisable) {
                return false;
            }
            return cursorWord.equals(lastNotEmptyWord) ? this.exclusiveDisableOptions.contains(lastNotEmptyWord) || this.exclusiveDisableOptions.contains(preLastNotEmptyWord) : this.exclusiveDisableOptions.contains(lastNotEmptyWord);
        }

        private boolean intersect(@Nullable Set<String> a, @Nullable Set<String> b) {
            if (a == null || b == null) {
                return false;
            }
            for (String s : a) {
                if (!b.contains(s)) continue;
                return true;
            }
            return false;
        }
    }
}

