/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcQueryMetadataResult
extends JdbcResult {
    private List<JdbcColumnMeta> meta;

    JdbcQueryMetadataResult() {
        super((byte)5);
    }

    JdbcQueryMetadataResult(long queryId, List<JdbcColumnMeta> meta) {
        super((byte)5);
        this.meta = meta;
    }

    public List<JdbcColumnMeta> meta() {
        return this.meta;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        if (F.isEmpty(this.meta)) {
            writer.writeInt(0);
        } else {
            writer.writeInt(this.meta.size());
            for (JdbcColumnMeta m : this.meta) {
                m.writeBinary(writer, protoCtx);
            }
        }
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        int size = reader.readInt();
        if (size == 0) {
            this.meta = Collections.emptyList();
        } else {
            this.meta = new ArrayList<JdbcColumnMeta>(size);
            for (int i = 0; i < size; ++i) {
                JdbcColumnMeta m = new JdbcColumnMeta();
                m.readBinary(reader, protoCtx);
                this.meta.add(m);
            }
        }
    }

    @Override
    public String toString() {
        return S.toString(JdbcQueryMetadataResult.class, this);
    }
}

