/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.rocksdb;

import org.apache.ignite3.internal.rocksdb.RocksIteratorAdapter;
import org.apache.ignite3.internal.util.IgniteSpinBusyLock;
import org.rocksdb.RocksIterator;

public abstract class BusyRocksIteratorAdapter<T>
extends RocksIteratorAdapter<T> {
    private final IgniteSpinBusyLock busyLock;

    protected BusyRocksIteratorAdapter(IgniteSpinBusyLock busyLock, RocksIterator it) {
        super(it);
        this.busyLock = busyLock;
    }

    protected abstract void handleBusyFail();

    protected void handeBusySuccess() {
    }

    private void handleBusyFail0() {
        this.handleBusyFail();
        assert (false) : "handleBusy() should have thrown an exception.";
    }

    @Override
    public boolean hasNext() {
        if (!this.busyLock.enterBusy()) {
            this.handleBusyFail0();
        }
        try {
            this.handeBusySuccess();
            boolean bl = super.hasNext();
            return bl;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public T next() {
        if (!this.busyLock.enterBusy()) {
            this.handleBusyFail0();
        }
        try {
            this.handeBusySuccess();
            Object t = super.next();
            return t;
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }

    @Override
    public void close() {
        if (!this.busyLock.enterBusy()) {
            this.handleBusyFail0();
        }
        try {
            this.handeBusySuccess();
            super.close();
        }
        finally {
            this.busyLock.leaveBusy();
        }
    }
}

