/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite3.raft.jraft.RaftMessagesFactory;
import org.apache.ignite3.raft.jraft.entity.PeerId;
import org.apache.ignite3.raft.jraft.error.RaftError;
import org.apache.ignite3.raft.jraft.rpc.CliRequests;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite3.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class RemovePeerRequestProcessor
extends BaseCliRequestProcessor<CliRequests.RemovePeerRequest> {
    public RemovePeerRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.RemovePeerRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.RemovePeerRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.RemovePeerRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldPeers = ctx.node.listPeers();
        PeerId removingPeer = new PeerId();
        String removingPeerIdStr = request.peerId();
        if (!removingPeer.parse(removingPeerIdStr)) {
            return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", removingPeerIdStr);
        }
        LOG.info("Receive RemovePeerRequest to {} from {}, removing {}", ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), removingPeerIdStr);
        ctx.node.removePeer(removingPeer, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                ArrayList<String> oldPeersList = new ArrayList<String>();
                ArrayList<String> newPeersList = new ArrayList<String>();
                for (PeerId oldPeer : oldPeers) {
                    oldPeersList.add(oldPeer.toString());
                    if (oldPeer.equals(removingPeer)) continue;
                    newPeersList.add(oldPeer.toString());
                }
                CliRequests.RemovePeerResponse rb = this.msgFactory().removePeerResponse().newPeersList(newPeersList).oldPeersList(oldPeersList).build();
                done.sendResponse(rb);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.RemovePeerRequest.class.getName();
    }
}

