/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.encryptionsdk.jce;

import com.amazonaws.encryptionsdk.CryptoAlgorithm;
import com.amazonaws.encryptionsdk.DataKey;
import com.amazonaws.encryptionsdk.EncryptedDataKey;
import com.amazonaws.encryptionsdk.MasterKey;
import com.amazonaws.encryptionsdk.exception.AwsCryptoException;
import com.amazonaws.encryptionsdk.exception.UnsupportedProviderException;
import com.amazonaws.encryptionsdk.internal.EncryptionContextSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class JceMasterKey
extends MasterKey<JceMasterKey> {
    private static final byte[] EMPTY_ARRAY = new byte[0];
    private final SecureRandom rnd = new SecureRandom();
    private final Key wrappingKey_;
    private final Key unwrappingKey_;
    private final String providerName_;
    private final String keyId_;
    private final byte[] keyIdBytes_;

    public static JceMasterKey getInstance(SecretKey key, String provider, String keyId, String wrappingAlgorithm) {
        switch (wrappingAlgorithm) {
            case "AES/GCM/NoPadding": {
                return new AesGcm(key, provider, keyId);
            }
        }
        throw new IllegalArgumentException("Right now only AES/GCM/NoPadding is supported");
    }

    public static JceMasterKey getInstance(PublicKey wrappingKey, PrivateKey unwrappingKey, String provider, String keyId, String wrappingAlgorithm) {
        if (wrappingAlgorithm.toUpperCase().startsWith("RSA/ECB/")) {
            return new Rsa(wrappingKey, unwrappingKey, provider, keyId, wrappingAlgorithm);
        }
        throw new UnsupportedOperationException("Currently only RSA asymmetric algorithms are supported");
    }

    protected JceMasterKey(Key wrappingKey, Key unwrappingKey, String providerName, String keyId) {
        this.wrappingKey_ = wrappingKey;
        this.unwrappingKey_ = unwrappingKey;
        this.providerName_ = providerName;
        this.keyId_ = keyId;
        this.keyIdBytes_ = this.keyId_.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String getProviderId() {
        return this.providerName_;
    }

    @Override
    public String getKeyId() {
        return this.keyId_;
    }

    @Override
    public DataKey<JceMasterKey> generateDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext) {
        byte[] rawKey = new byte[algorithm.getDataKeyLength()];
        this.rnd.nextBytes(rawKey);
        SecretKeySpec key = new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo());
        return this.encryptRawKey(key, rawKey, encryptionContext);
    }

    @Override
    public DataKey<JceMasterKey> encryptDataKey(CryptoAlgorithm algorithm, Map<String, String> encryptionContext, DataKey<?> dataKey) {
        SecretKey key = dataKey.getKey();
        if (!key.getFormat().equals("RAW")) {
            throw new IllegalArgumentException("Can only re-encrypt data keys which are in RAW format, not " + dataKey.getKey().getFormat());
        }
        if (!key.getAlgorithm().equalsIgnoreCase(algorithm.getDataKeyAlgo())) {
            throw new IllegalArgumentException("Incorrect key algorithm. Expected " + key.getAlgorithm() + " but got " + algorithm.getKeyAlgo());
        }
        byte[] rawKey = key.getEncoded();
        DataKey<JceMasterKey> result = this.encryptRawKey(key, rawKey, encryptionContext);
        Arrays.fill(rawKey, (byte)0);
        return result;
    }

    protected DataKey<JceMasterKey> encryptRawKey(SecretKey key, byte[] rawKey, Map<String, String> encryptionContext) {
        try {
            WrappingData wData = this.buildWrappingCipher(this.wrappingKey_, encryptionContext);
            Cipher cipher = wData.cipher;
            byte[] encryptedKey = cipher.doFinal(rawKey);
            byte[] provInfo = new byte[this.keyIdBytes_.length + wData.extraInfo.length];
            System.arraycopy(this.keyIdBytes_, 0, provInfo, 0, this.keyIdBytes_.length);
            System.arraycopy(wData.extraInfo, 0, provInfo, this.keyIdBytes_.length, wData.extraInfo.length);
            return new DataKey<JceMasterKey>(key, encryptedKey, provInfo, this);
        }
        catch (GeneralSecurityException gsex) {
            throw new AwsCryptoException(gsex);
        }
    }

    @Override
    public DataKey<JceMasterKey> decryptDataKey(CryptoAlgorithm algorithm, Collection<? extends EncryptedDataKey> encryptedDataKeys, Map<String, String> encryptionContext) throws UnsupportedProviderException, AwsCryptoException {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (EncryptedDataKey encryptedDataKey : encryptedDataKeys) {
            try {
                DataKey<JceMasterKey> result;
                if (!encryptedDataKey.getProviderId().equals(this.getProviderId()) || !JceMasterKey.arrayPrefixEquals(encryptedDataKey.getProviderInformation(), this.keyIdBytes_, this.keyIdBytes_.length) || (result = this.actualDecrypt(algorithm, encryptedDataKey, encryptionContext)) == null) continue;
                return result;
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        throw this.buildCannotDecryptDksException(exceptions);
    }

    protected DataKey<JceMasterKey> actualDecrypt(CryptoAlgorithm algorithm, EncryptedDataKey edk, Map<String, String> encryptionContext) throws GeneralSecurityException {
        Cipher cipher = this.buildUnwrappingCipher(this.unwrappingKey_, edk.getProviderInformation(), this.keyIdBytes_.length, encryptionContext);
        byte[] rawKey = cipher.doFinal(edk.getEncryptedDataKey());
        if (rawKey.length != algorithm.getDataKeyLength()) {
            return null;
        }
        return new DataKey<JceMasterKey>(new SecretKeySpec(rawKey, algorithm.getDataKeyAlgo()), edk.getEncryptedDataKey(), edk.getProviderInformation(), this);
    }

    protected static boolean arrayPrefixEquals(byte[] a, byte[] b, int len) {
        if (a == null || b == null || a.length < len || b.length < len) {
            return false;
        }
        for (int x = 0; x < len; ++x) {
            if (a[x] == b[x]) continue;
            return false;
        }
        return true;
    }

    protected abstract WrappingData buildWrappingCipher(Key var1, Map<String, String> var2) throws GeneralSecurityException;

    protected abstract Cipher buildUnwrappingCipher(Key var1, byte[] var2, int var3, Map<String, String> var4) throws GeneralSecurityException;

    private static class AesGcm
    extends JceMasterKey {
        private static final int NONCE_LENGTH = 12;
        private static final int TAG_LENGTH = 128;
        private static final String TRANSFORMATION = "AES/GCM/NoPadding";
        private final SecureRandom rnd = new SecureRandom();

        public AesGcm(SecretKey key, String providerName, String keyId) {
            super(key, key, providerName, keyId);
        }

        private static byte[] specToBytes(GCMParameterSpec spec) {
            byte[] nonce = spec.getIV();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DataOutputStream dos = new DataOutputStream(baos);){
                dos.writeInt(spec.getTLen());
                dos.writeInt(nonce.length);
                dos.write(nonce);
                dos.close();
                baos.close();
            }
            catch (IOException ex) {
                throw new AssertionError("Impossible exception", ex);
            }
            return baos.toByteArray();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static GCMParameterSpec bytesToSpec(byte[] data, int offset) {
            ByteArrayInputStream bais = new ByteArrayInputStream(data, offset, data.length - offset);
            try (DataInputStream dis = new DataInputStream(bais);){
                int tagLen = dis.readInt();
                int nonceLen = dis.readInt();
                byte[] nonce = new byte[nonceLen];
                dis.readFully(nonce);
                GCMParameterSpec gCMParameterSpec = new GCMParameterSpec(tagLen, nonce);
                return gCMParameterSpec;
            }
            catch (IOException ex) {
                throw new AssertionError("Impossible exception", ex);
            }
        }

        @Override
        protected WrappingData buildWrappingCipher(Key key, Map<String, String> encryptionContext) throws GeneralSecurityException {
            byte[] nonce = new byte[12];
            this.rnd.nextBytes(nonce);
            GCMParameterSpec spec = new GCMParameterSpec(128, nonce);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(1, key, spec);
            byte[] aad = EncryptionContextSerializer.serialize(encryptionContext);
            cipher.updateAAD(aad);
            return new WrappingData(cipher, AesGcm.specToBytes(spec));
        }

        @Override
        protected Cipher buildUnwrappingCipher(Key key, byte[] extraInfo, int offset, Map<String, String> encryptionContext) throws GeneralSecurityException {
            GCMParameterSpec spec = AesGcm.bytesToSpec(extraInfo, offset);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, key, spec);
            byte[] aad = EncryptionContextSerializer.serialize(encryptionContext);
            cipher.updateAAD(aad);
            return cipher;
        }
    }

    private static class Rsa
    extends JceMasterKey {
        private final String transformation_;

        private Rsa(PublicKey wrappingKey, PrivateKey unwrappingKey, String providerName, String keyId, String transformation) {
            super(wrappingKey, unwrappingKey, providerName, keyId);
            this.transformation_ = transformation;
        }

        @Override
        protected WrappingData buildWrappingCipher(Key key, Map<String, String> encryptionContext) throws GeneralSecurityException {
            Cipher cipher = Cipher.getInstance(this.transformation_, "BC");
            cipher.init(1, key);
            return new WrappingData(cipher, EMPTY_ARRAY);
        }

        @Override
        protected Cipher buildUnwrappingCipher(Key key, byte[] extraInfo, int offset, Map<String, String> encryptionContext) throws GeneralSecurityException {
            if (extraInfo.length != offset) {
                throw new IllegalArgumentException("Extra info must be empty for RSA keys");
            }
            Cipher cipher = Cipher.getInstance(this.transformation_, "BC");
            cipher.init(2, key);
            return cipher;
        }
    }

    private static class WrappingData {
        public final Cipher cipher;
        public final byte[] extraInfo;

        public WrappingData(Cipher cipher, byte[] extraInfo) {
            this.cipher = cipher;
            this.extraInfo = extraInfo != null ? extraInfo : EMPTY_ARRAY;
        }
    }
}

