/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DhcpOptions
implements Serializable,
Cloneable {
    private String dhcpOptionsId;
    private SdkInternalList<DhcpConfiguration> dhcpConfigurations;
    private SdkInternalList<Tag> tags;

    public void setDhcpOptionsId(String dhcpOptionsId) {
        this.dhcpOptionsId = dhcpOptionsId;
    }

    public String getDhcpOptionsId() {
        return this.dhcpOptionsId;
    }

    public DhcpOptions withDhcpOptionsId(String dhcpOptionsId) {
        this.setDhcpOptionsId(dhcpOptionsId);
        return this;
    }

    public List<DhcpConfiguration> getDhcpConfigurations() {
        if (this.dhcpConfigurations == null) {
            this.dhcpConfigurations = new SdkInternalList();
        }
        return this.dhcpConfigurations;
    }

    public void setDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        if (dhcpConfigurations == null) {
            this.dhcpConfigurations = null;
            return;
        }
        this.dhcpConfigurations = new SdkInternalList(dhcpConfigurations);
    }

    public DhcpOptions withDhcpConfigurations(DhcpConfiguration ... dhcpConfigurations) {
        if (this.dhcpConfigurations == null) {
            this.setDhcpConfigurations((Collection<DhcpConfiguration>)new SdkInternalList(dhcpConfigurations.length));
        }
        for (DhcpConfiguration ele : dhcpConfigurations) {
            this.dhcpConfigurations.add((Object)ele);
        }
        return this;
    }

    public DhcpOptions withDhcpConfigurations(Collection<DhcpConfiguration> dhcpConfigurations) {
        this.setDhcpConfigurations(dhcpConfigurations);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public DhcpOptions withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public DhcpOptions withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDhcpOptionsId() != null) {
            sb.append("DhcpOptionsId: ").append(this.getDhcpOptionsId()).append(",");
        }
        if (this.getDhcpConfigurations() != null) {
            sb.append("DhcpConfigurations: ").append(this.getDhcpConfigurations()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DhcpOptions)) {
            return false;
        }
        DhcpOptions other = (DhcpOptions)obj;
        if (other.getDhcpOptionsId() == null ^ this.getDhcpOptionsId() == null) {
            return false;
        }
        if (other.getDhcpOptionsId() != null && !other.getDhcpOptionsId().equals(this.getDhcpOptionsId())) {
            return false;
        }
        if (other.getDhcpConfigurations() == null ^ this.getDhcpConfigurations() == null) {
            return false;
        }
        if (other.getDhcpConfigurations() != null && !other.getDhcpConfigurations().equals(this.getDhcpConfigurations())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDhcpOptionsId() == null ? 0 : this.getDhcpOptionsId().hashCode());
        hashCode = 31 * hashCode + (this.getDhcpConfigurations() == null ? 0 : this.getDhcpConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public DhcpOptions clone() {
        try {
            return (DhcpOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

