/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeMovingAddressesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeMovingAddressesRequestMarshaller
implements Marshaller<Request<DescribeMovingAddressesRequest>, DescribeMovingAddressesRequest> {
    public Request<DescribeMovingAddressesRequest> marshall(DescribeMovingAddressesRequest describeMovingAddressesRequest) {
        SdkInternalList describeMovingAddressesRequestFiltersList;
        if (describeMovingAddressesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeMovingAddressesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeMovingAddresses");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeMovingAddressesRequestPublicIpsList = (SdkInternalList)describeMovingAddressesRequest.getPublicIps();
        if (!describeMovingAddressesRequestPublicIpsList.isEmpty() || !describeMovingAddressesRequestPublicIpsList.isAutoConstruct()) {
            int publicIpsListIndex = 1;
            for (String describeMovingAddressesRequestPublicIpsListValue : describeMovingAddressesRequestPublicIpsList) {
                if (describeMovingAddressesRequestPublicIpsListValue != null) {
                    request.addParameter("PublicIp." + publicIpsListIndex, StringUtils.fromString((String)describeMovingAddressesRequestPublicIpsListValue));
                }
                ++publicIpsListIndex;
            }
        }
        if (describeMovingAddressesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeMovingAddressesRequest.getNextToken()));
        }
        if (!(describeMovingAddressesRequestFiltersList = (SdkInternalList)describeMovingAddressesRequest.getFilters()).isEmpty() || !describeMovingAddressesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeMovingAddressesRequestFiltersListValue : describeMovingAddressesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeMovingAddressesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeMovingAddressesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeMovingAddressesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeMovingAddressesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeMovingAddressesRequest.getMaxResults()));
        }
        return request;
    }
}

