/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.communication.tcp.internal;

import java.util.Collection;
import java.util.UUID;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.IgniteFeatures;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.discovery.IgniteDiscoverySpi;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite.spi.communication.tcp.messages.NodeIdMessage;
import org.apache.ignite.spi.discovery.DiscoverySpi;

public class ClusterStateProvider {
    private final Ignite ignite;
    private final Supplier<ClusterNode> locNodeSupplier;
    private final TcpCommunicationSpi tcpCommSpi;
    private final Supplier<Boolean> stoppedSupplier;
    private final Supplier<IgniteSpiContext> spiCtxWithoutLatchSupplier;
    private final IgniteLogger log;
    private final Supplier<Ignite> igniteExSupplier;

    public ClusterStateProvider(Ignite ignite, Supplier<ClusterNode> locNodeSupplier, TcpCommunicationSpi tcpCommSpi, Supplier<Boolean> stoppedSupplier, Supplier<IgniteSpiContext> spiCtxWithoutLatchSupplier, IgniteLogger log, Supplier<Ignite> igniteExSupplier) {
        this.ignite = ignite;
        this.locNodeSupplier = locNodeSupplier;
        this.tcpCommSpi = tcpCommSpi;
        this.stoppedSupplier = stoppedSupplier;
        this.spiCtxWithoutLatchSupplier = spiCtxWithoutLatchSupplier;
        this.log = log;
        this.igniteExSupplier = igniteExSupplier;
    }

    public boolean isLocalNodeDisconnected() {
        boolean disconnected = false;
        if (this.ignite instanceof IgniteKernal) {
            disconnected = ((IgniteEx)this.ignite).context().clientDisconnected();
        }
        return disconnected;
    }

    public boolean isSslEnabled() {
        return this.ignite.configuration().getSslContextFactory() != null;
    }

    public SSLEngine createSSLEngine() {
        return ((SSLContext)this.ignite.configuration().getSslContextFactory().create()).createSSLEngine();
    }

    public boolean isStopping() {
        return this.stoppedSupplier.get();
    }

    public long clientFailureDetectionTimeout() {
        return this.tcpCommSpi.clientFailureDetectionTimeout();
    }

    public IgniteSpiContext getSpiContext() {
        return this.tcpCommSpi.getSpiContext();
    }

    public IgniteSpiContext getSpiContextWithoutInitialLatch() {
        return this.spiCtxWithoutLatchSupplier.get();
    }

    public int getOutboundMessagesQueueSize() {
        return this.tcpCommSpi.getOutboundMessagesQueueSize();
    }

    public void dumpStats() {
        this.tcpCommSpi.dumpStats();
    }

    public boolean isHandshakeWaitSupported() {
        DiscoverySpi discoSpi = this.ignite.configuration().getDiscoverySpi();
        if (discoSpi instanceof IgniteDiscoverySpi) {
            return ((IgniteDiscoverySpi)discoSpi).allNodesSupport(IgniteFeatures.TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE);
        }
        Collection<ClusterNode> nodes = discoSpi.getRemoteNodes();
        return IgniteFeatures.allNodesSupports(nodes, IgniteFeatures.TCP_COMMUNICATION_SPI_HANDSHAKE_WAIT_MESSAGE);
    }

    public NodeIdMessage nodeIdMessage() {
        UUID locNodeId = this.ignite != null && this.ignite instanceof IgniteKernal ? ((IgniteEx)this.ignite).context().localNodeId() : this.safeLocalNodeId();
        return new NodeIdMessage(locNodeId);
    }

    private UUID safeLocalNodeId() {
        UUID id;
        ClusterNode locNode = this.locNodeSupplier.get();
        if (locNode == null) {
            U.warn(this.log, "Local node is not started or fully initialized [isStopping=" + this.isStopping() + ']');
            id = new UUID(0L, 0L);
        } else {
            id = locNode.id();
        }
        return id;
    }
}

