/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.doc.internal;

import com.sun.javadoc.Tag;
import com.sun.tools.doclets.Taglet;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ReviewedTag
implements Taglet {
    private static final String NAME = "reviewed";
    static final Set<String> REVIEWED = Collections.synchronizedSet(new LinkedHashSet());

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("[WARNING] " + REVIEWED.size() + " files reviewed.  Remove {@reviewed} tags before release.");
                for (String s : REVIEWED) {
                    System.out.println("[REVIEWED] " + s);
                }
            }
        });
    }

    public String getName() {
        return NAME;
    }

    public boolean inField() {
        return true;
    }

    public boolean inConstructor() {
        return true;
    }

    public boolean inMethod() {
        return true;
    }

    public boolean inOverview() {
        return true;
    }

    public boolean inPackage() {
        return true;
    }

    public boolean inType() {
        return true;
    }

    public boolean isInlineTag() {
        return true;
    }

    public static void register(Map tagletMap) {
        ReviewedTag tag = new ReviewedTag();
        tagletMap.put(tag.getName(), tag);
    }

    public String toString(Tag tag) {
        String label = tag.text();
        if (label == null || label.isEmpty()) {
            label = "Reviewed";
        }
        String file = tag.position().file().getAbsolutePath();
        REVIEWED.add(file);
        return "<reviewed>" + label + "</reviewed>";
    }

    public String toString(Tag[] tags) {
        return null;
    }
}

