/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.taglib.core;

import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class DelegateConverter
implements Converter,
StateHolder {
    private ValueExpression _converterId;
    private ValueExpression _binding;
    private String _converterIdString = null;

    public DelegateConverter() {
    }

    public DelegateConverter(ValueExpression id, ValueExpression binding, String converterIdString) {
        this._converterId = id;
        this._binding = binding;
        this._converterIdString = converterIdString;
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public void restoreState(FacesContext facesContext, Object state) {
        Object[] values = (Object[])state;
        this._converterId = (ValueExpression)values[0];
        this._binding = (ValueExpression)values[1];
        this._converterIdString = (String)values[2];
    }

    @Override
    public Object saveState(FacesContext facesContext) {
        Object[] values = new Object[]{this._converterId, this._binding, this._converterIdString};
        return values;
    }

    @Override
    public void setTransient(boolean arg0) {
    }

    public Object getAsObject(FacesContext facesContext, UIComponent component, String value) {
        return this._getDelegate().getAsObject(facesContext, component, value);
    }

    public String getAsString(FacesContext facesContext, UIComponent component, Object value) {
        return this._getDelegate().getAsString(facesContext, component, value);
    }

    private Converter _getDelegate() {
        return this._createConverter();
    }

    private Converter _createConverter() {
        Converter converter = null;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ELContext elContext = facesContext.getELContext();
        if (this._binding != null) {
            try {
                converter = (Converter)this._binding.getValue(elContext);
                if (converter != null) {
                    return converter;
                }
            }
            catch (Exception e) {
                throw new ConverterException("Exception creating converter using binding", (Throwable)e);
            }
        }
        if (this._converterId != null || this._converterIdString != null) {
            try {
                if (null != this._converterIdString) {
                    converter = facesContext.getApplication().createConverter(this._converterIdString);
                } else {
                    String converterId = (String)this._converterId.getValue(elContext);
                    converter = facesContext.getApplication().createConverter(converterId);
                }
                if (converter != null && this._binding != null) {
                    this._binding.setValue(elContext, (Object)converter);
                }
            }
            catch (Exception e) {
                throw new ConverterException("Exception creating converter with converterId: " + this._converterId, (Throwable)e);
            }
        }
        if (converter == null) {
            throw new IllegalStateException("Could not create converter. Please specify a valid converterId or a non-null binding.");
        }
        return converter;
    }
}

