/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;

public final class ClassUtils
extends org.apache.myfaces.core.api.shared.lang.ClassUtils {
    private static final Logger log = Logger.getLogger(ClassUtils.class.getName());

    public static <T> T buildApplicationObject(Class<T> interfaceClass, Collection<String> classNamesIterator, T defaultObject) {
        return ClassUtils.buildApplicationObject(interfaceClass, null, null, classNamesIterator, defaultObject);
    }

    public static <T> T buildApplicationObject(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, Collection<String> classNamesIterator, T defaultObject) {
        T current = defaultObject;
        for (String implClassName : classNamesIterator) {
            Class implClass = ClassUtils.simpleClassForName(implClassName);
            if (!interfaceClass.isAssignableFrom(implClass)) {
                throw new IllegalArgumentException("Class " + implClassName + " is no " + interfaceClass.getName());
            }
            if (current == null) {
                current = ClassUtils.newInstance(implClass);
                continue;
            }
            T newCurrent = null;
            try {
                Constructor delegationConstructor = null;
                if (extendedInterfaceClass != null && extendedInterfaceClass.isAssignableFrom(current.getClass())) {
                    try {
                        delegationConstructor = implClass.getConstructor(extendedInterfaceClass);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
                if (delegationConstructor == null) {
                    delegationConstructor = implClass.getConstructor(interfaceClass);
                }
                try {
                    newCurrent = delegationConstructor.newInstance(current);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    log.log(Level.SEVERE, e.getMessage(), e);
                    throw new FacesException(e);
                }
            }
            catch (NoSuchMethodException e) {
                newCurrent = ClassUtils.newInstance(implClass);
            }
            current = ClassUtils.wrapBackwardCompatible(interfaceClass, extendedInterfaceClass, extendedInterfaceWrapperClass, current, newCurrent);
        }
        return current;
    }

    public static <T> T wrapBackwardCompatible(Class<T> interfaceClass, Class<? extends T> extendedInterfaceClass, Class<? extends T> extendedInterfaceWrapperClass, T defaultObject, T newCurrent) {
        T current = newCurrent;
        if (extendedInterfaceWrapperClass != null && !extendedInterfaceClass.isAssignableFrom(current.getClass())) {
            try {
                Constructor<T> wrapperConstructor = extendedInterfaceWrapperClass.getConstructor(interfaceClass, extendedInterfaceClass);
                current = wrapperConstructor.newInstance(newCurrent, defaultObject);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
                throw new FacesException(e);
            }
        }
        return current;
    }

    protected static final String paramString(Class<?> ... types) {
        if (types != null) {
            StringBuilder sb = new StringBuilder();
            for (Class<?> type : types) {
                sb.append(type.getName()).append(", ");
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
            }
            return sb.toString();
        }
        return null;
    }
}

