/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.myfaces.config.element.NavigationCase;
import org.apache.myfaces.config.element.NavigationRule;

public final class NavigationUtils {
    public static Set<javax.faces.application.NavigationCase> convertNavigationCasesToAPI(NavigationRule rule) {
        List<? extends NavigationCase> configCases = rule.getNavigationCases();
        HashSet<javax.faces.application.NavigationCase> apiCases = new HashSet<javax.faces.application.NavigationCase>(configCases.size());
        for (NavigationCase navigationCase : configCases) {
            if (navigationCase.getRedirect() != null) {
                String includeViewParamsAttribute = navigationCase.getRedirect().getIncludeViewParams();
                boolean includeViewParams = false;
                if (includeViewParamsAttribute != null) {
                    includeViewParams = Boolean.valueOf(includeViewParamsAttribute);
                }
                apiCases.add(new javax.faces.application.NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), navigationCase.getRedirect().getViewParams(), true, includeViewParams));
                continue;
            }
            apiCases.add(new javax.faces.application.NavigationCase(rule.getFromViewId(), navigationCase.getFromAction(), navigationCase.getFromOutcome(), navigationCase.getIf(), navigationCase.getToViewId(), null, false, false));
        }
        return apiCases;
    }

    public static Map<String, List<String>> getEvaluatedNavigationParameters(FacesContext facesContext, Map<String, List<String>> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            HashMap<String, List<String>> evaluatedParameters = new HashMap<String, List<String>>(parameters.size());
            for (Map.Entry<String, List<String>> pair : parameters.entrySet()) {
                boolean containsEL = false;
                for (String value : pair.getValue()) {
                    if (!NavigationUtils._isExpression(value)) continue;
                    containsEL = true;
                    break;
                }
                if (containsEL) {
                    evaluatedParameters.put(pair.getKey(), NavigationUtils._evaluateValueExpressions(facesContext, pair.getValue()));
                    continue;
                }
                evaluatedParameters.put(pair.getKey(), pair.getValue());
            }
            return evaluatedParameters;
        }
        return parameters;
    }

    private static List<String> _evaluateValueExpressions(FacesContext context, List<String> values) {
        ArrayList<String> target = new ArrayList<String>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (value == null) continue;
            if (NavigationUtils._isExpression(value)) {
                value = (String)context.getApplication().evaluateExpressionGet(context, value, String.class);
            }
            target.add(value);
        }
        return target;
    }

    private static boolean _isExpression(String text) {
        return text != null && text.contains("#{");
    }
}

