/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.webapp;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.myfaces.config.annotation.LifecycleProviderFactory;
import org.apache.myfaces.shared.util.ClassUtils;
import org.apache.myfaces.webapp.FacesInitializer;
import org.apache.myfaces.webapp.FacesInitializerFactory;
import org.apache.myfaces.webapp.StartupListener;

public class StartupServletContextListener
implements ServletContextListener {
    static final String FACES_INIT_DONE = "org.apache.myfaces.webapp.StartupServletContextListener.FACES_INIT_DONE";
    static final String FACES_INIT_PLUGINS = "org.apache.myfaces.FACES_INIT_PLUGINS";
    private static final byte FACES_INIT_PHASE_PREINIT = 0;
    private static final byte FACES_INIT_PHASE_POSTINIT = 1;
    private static final byte FACES_INIT_PHASE_PREDESTROY = 2;
    private static final byte FACES_INIT_PHASE_POSTDESTROY = 3;
    private static final Logger log = Logger.getLogger(StartupServletContextListener.class.getName());
    private FacesInitializer _facesInitializer;
    private ServletContext _servletContext;

    public void contextInitialized(ServletContextEvent event) {
        if (this._servletContext != null) {
            throw new IllegalStateException("context is already initialized");
        }
        this._servletContext = event.getServletContext();
        Boolean b = (Boolean)this._servletContext.getAttribute(FACES_INIT_DONE);
        if (b == null || !b.booleanValue()) {
            long start = System.currentTimeMillis();
            if (this._facesInitializer == null) {
                this._facesInitializer = FacesInitializerFactory.getFacesInitializer(this._servletContext);
            }
            FacesContext facesContext = this._facesInitializer.initStartupFacesContext(this._servletContext);
            this.dispatchInitializationEvent(event, 0);
            this._facesInitializer.initFaces(this._servletContext);
            this.dispatchInitializationEvent(event, 1);
            this._servletContext.setAttribute(FACES_INIT_DONE, (Object)Boolean.TRUE);
            this._facesInitializer.destroyStartupFacesContext(facesContext);
            log.log(Level.INFO, "MyFaces Core has started, it took [" + (System.currentTimeMillis() - start) + "] ms.");
        } else {
            log.info("MyFaces already initialized");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        if (this._facesInitializer != null && this._servletContext != null) {
            FacesContext facesContext = this._facesInitializer.initShutdownFacesContext(this._servletContext);
            this.dispatchInitializationEvent(event, 2);
            this._facesInitializer.destroyFaces(this._servletContext);
            LifecycleProviderFactory.getLifecycleProviderFactory().release();
            if (facesContext != null) {
                this._facesInitializer.destroyShutdownFacesContext(facesContext);
            }
            FactoryFinder.releaseFactories();
            this.dispatchInitializationEvent(event, 3);
        }
        this._servletContext = null;
    }

    public void setFacesInitializer(FacesInitializer facesInitializer) {
        if (this._facesInitializer != null && this._facesInitializer != facesInitializer && this._servletContext != null) {
            this._facesInitializer.destroyFaces(this._servletContext);
        }
        this._facesInitializer = facesInitializer;
        if (this._servletContext != null) {
            facesInitializer.initFaces(this._servletContext);
        }
    }

    private boolean loadFacesInitPluginsViaServiceLoader() {
        try {
            Class<?> serviceLoader = ClassUtils.getContextClassLoader().loadClass("java.util.ServiceLoader");
            Method m = serviceLoader.getDeclaredMethod("load", Class.class, ClassLoader.class);
            Object loader = m.invoke(serviceLoader, StartupListener.class, ClassUtils.getContextClassLoader());
            m = loader.getClass().getDeclaredMethod("iterator", new Class[0]);
            Iterator it = (Iterator)m.invoke(loader, new Object[0]);
            LinkedList listeners = new LinkedList();
            if (!it.hasNext()) {
                return false;
            }
            while (it.hasNext()) {
                listeners.add(it.next());
            }
            this._servletContext.setAttribute(FACES_INIT_PLUGINS, listeners);
            return true;
        }
        catch (ClassNotFoundException serviceLoader) {
        }
        catch (NoSuchMethodException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            log.log(Level.SEVERE, e.getMessage(), e);
        }
        return false;
    }

    private void loadFacesInitViaContextParam() {
        String plugins = this._servletContext.getInitParameter(FACES_INIT_PLUGINS);
        if (plugins == null) {
            return;
        }
        log.info("MyFaces Plugins found");
        String[] pluginEntries = plugins.split(",");
        ArrayList<StartupListener> listeners = new ArrayList<StartupListener>(pluginEntries.length);
        for (String pluginEntry : pluginEntries) {
            try {
                Class<?> pluginClass = null;
                pluginClass = ClassUtils.getContextClassLoader().loadClass(pluginEntry);
                if (pluginClass == null) {
                    pluginClass = this.getClass().getClassLoader().loadClass(pluginEntry);
                }
                listeners.add((StartupListener)pluginClass.newInstance());
            }
            catch (ClassNotFoundException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (InstantiationException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this._servletContext.setAttribute(FACES_INIT_PLUGINS, listeners);
    }

    private void dispatchInitializationEvent(ServletContextEvent event, int operation) {
        List pluginEntries;
        if (operation == 0 && !this.loadFacesInitPluginsViaServiceLoader()) {
            this.loadFacesInitViaContextParam();
        }
        if ((pluginEntries = (List)this._servletContext.getAttribute(FACES_INIT_PLUGINS)) == null) {
            return;
        }
        block5: for (StartupListener initializer : pluginEntries) {
            log.info("Processing plugin");
            switch (operation) {
                case 0: {
                    initializer.preInit(event);
                    continue block5;
                }
                case 1: {
                    initializer.postInit(event);
                    continue block5;
                }
                case 2: {
                    initializer.preDestroy(event);
                    continue block5;
                }
            }
            initializer.postDestroy(event);
        }
        log.info("Processing MyFaces plugins done");
    }
}

