/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.el.PropertyNotWritableException;
import jakarta.faces.context.FacesContext;
import jakarta.faces.el.EvaluationException;
import jakarta.faces.el.VariableResolver;
import java.beans.FeatureDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.myfaces.el.VariableResolverImpl;

public final class VariableResolverToELResolver
extends ELResolver {
    private static final ThreadLocal<Collection<String>> propertyGuardThreadLocal = new ThreadLocal();
    private VariableResolver variableResolver;
    private boolean isDefaultLegacyVariableResolver;

    private static Collection<String> getPropertyGuard() {
        Collection<String> propertyGuard = propertyGuardThreadLocal.get();
        if (propertyGuard == null) {
            propertyGuard = new HashSet<String>();
            propertyGuardThreadLocal.set(propertyGuard);
        }
        return propertyGuard;
    }

    public VariableResolverToELResolver(VariableResolver variableResolver) {
        this.variableResolver = variableResolver;
        this.isDefaultLegacyVariableResolver = this.variableResolver instanceof VariableResolverImpl;
    }

    public VariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getValue(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base != null) {
            return null;
        }
        if (property == null) {
            throw new PropertyNotFoundException();
        }
        context.setPropertyResolved(true);
        if (!(property instanceof String)) {
            return null;
        }
        String strProperty = (String)property;
        Collection<String> propertyGuard = VariableResolverToELResolver.getPropertyGuard();
        Object result = null;
        try {
            if (!propertyGuard.contains(strProperty)) {
                propertyGuard.add(strProperty);
                result = this.variableResolver.resolveVariable(VariableResolverToELResolver.facesContext(context), strProperty);
            }
        }
        catch (jakarta.faces.el.PropertyNotFoundException e) {
            try {
                context.setPropertyResolved(false);
                throw new PropertyNotFoundException(e.getMessage(), (Throwable)e);
                catch (EvaluationException e2) {
                    context.setPropertyResolved(false);
                    throw new ELException(e2.getMessage(), (Throwable)e2);
                }
                catch (RuntimeException e3) {
                    context.setPropertyResolved(false);
                    throw e3;
                }
            }
            catch (Throwable throwable) {
                propertyGuard.remove(strProperty);
                if (propertyGuard.isEmpty()) {
                    propertyGuardThreadLocal.remove();
                }
                context.setPropertyResolved(result != null);
                throw throwable;
            }
        }
        propertyGuard.remove(strProperty);
        if (propertyGuard.isEmpty()) {
            propertyGuardThreadLocal.remove();
        }
        context.setPropertyResolved(result != null);
        return result;
    }

    private static FacesContext facesContext(ELContext context) {
        return (FacesContext)context.getContext(FacesContext.class);
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base != null) {
            return null;
        }
        return String.class;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) throws NullPointerException, PropertyNotFoundException, PropertyNotWritableException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return;
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return false;
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws NullPointerException, PropertyNotFoundException, ELException {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        if (base == null && property == null) {
            throw new PropertyNotFoundException();
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (this.isDefaultLegacyVariableResolver) {
            return null;
        }
        return null;
    }
}

