/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.application.ProjectStage;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UISelectItems;
import jakarta.faces.component.UISelectMany;
import jakarta.faces.component.UISelectOne;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.core.api.shared.AttributeUtils;
import org.apache.myfaces.core.api.shared.SelectItemsIterator;
import org.apache.myfaces.core.api.shared.SharedRendererUtils;
import org.apache.myfaces.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.renderkit.html.util.SelectItemInfo;

public class SelectItemsUtils {
    private static final Logger LOGGER = Logger.getLogger(SelectItemsUtils.class.getName());
    private static final char TABULATOR = '\t';

    public static List<SelectItemInfo> getSelectItemInfoList(UISelectMany uiSelectMany, FacesContext facesContext) {
        ArrayList<SelectItemInfo> list = new ArrayList<SelectItemInfo>();
        SelectItemsIterator iter = new SelectItemsIterator((UIComponent)uiSelectMany, facesContext);
        while (iter.hasNext()) {
            list.add(new SelectItemInfo(iter.next(), iter.getCurrentComponent(), iter.getCurrentValue()));
        }
        return list;
    }

    public static List<SelectItemInfo> getSelectItemInfoList(UISelectOne uiSelectOne, FacesContext facesContext) {
        ArrayList<SelectItemInfo> list = new ArrayList<SelectItemInfo>();
        SelectItemsIterator iter = new SelectItemsIterator((UIComponent)uiSelectOne, facesContext);
        while (iter.hasNext()) {
            list.add(new SelectItemInfo(iter.next(), iter.getCurrentComponent(), iter.getCurrentValue()));
        }
        return list;
    }

    public static void renderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List<SelectItemInfo> selectItemList) throws IOException {
        AtomicBoolean anyItemSelected = null;
        if (component instanceof UISelectOne && context.isProjectStage(ProjectStage.Development)) {
            anyItemSelected = new AtomicBoolean(false);
        }
        SelectItemsUtils.internalRenderSelectOptions(context, component, converter, lookupSet, selectItemList, anyItemSelected);
        if (anyItemSelected != null && !anyItemSelected.get()) {
            LOGGER.log(Level.WARNING, "UISelectOne[clientId={0}, value={1}] rendered without selection. The first item will be displayed as selected, which could lead to unexpected behaviors.", new Object[]{component.getClientId(context), ((UIInput)component).getValue()});
        }
    }

    protected static void internalRenderSelectOptions(FacesContext context, UIComponent component, Converter converter, Set lookupSet, List<SelectItemInfo> selectItemList, AtomicBoolean anyItemSelected) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean hideNoSelectionOption = HtmlRendererUtils.isHideNoSelectionOption(component);
        boolean componentDisabled = SelectItemsUtils.isTrue(component.getAttributes().get("disabled"));
        for (int i = 0; i < selectItemList.size(); ++i) {
            boolean escape;
            boolean disabled;
            SelectItemInfo selectItemInfo = selectItemList.get(i);
            SelectItem selectItem = selectItemInfo.getItem();
            if (selectItem instanceof SelectItemGroup) {
                writer.startElement("optgroup", selectItemInfo.getComponent());
                writer.writeAttribute("label", (Object)selectItem.getLabel(), null);
                SelectItem[] selectItems = ((SelectItemGroup)selectItem).getSelectItems();
                ArrayList<SelectItemInfo> selectItemsGroupList = new ArrayList<SelectItemInfo>(selectItems.length);
                for (SelectItem item : selectItems) {
                    selectItemsGroupList.add(new SelectItemInfo(item, null));
                }
                SelectItemsUtils.internalRenderSelectOptions(context, component, converter, lookupSet, selectItemsGroupList, anyItemSelected);
                writer.endElement("optgroup");
                continue;
            }
            String itemStrValue = SharedRendererUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Converter)converter, (SelectItem)selectItem);
            boolean selected = lookupSet.contains(itemStrValue);
            if (hideNoSelectionOption && selectItem.isNoSelectionOption() && !lookupSet.isEmpty() && (lookupSet.size() != 1 || !lookupSet.contains("")) && !selected) continue;
            writer.write(9);
            boolean wroteRequestMapVarValue = false;
            Object oldRequestMapVarValue = null;
            String var = null;
            if (selectItemInfo != null && selectItemInfo.getComponent() instanceof UISelectItems && (var = (String)selectItemInfo.getComponent().getAttributes().get("var")) != null && !var.isEmpty()) {
                oldRequestMapVarValue = context.getExternalContext().getRequestMap().put(var, selectItemInfo.getValue());
                wroteRequestMapVarValue = true;
            }
            writer.startElement("option", selectItemInfo.getComponent());
            if (itemStrValue != null) {
                writer.writeAttribute("value", (Object)itemStrValue, null);
            } else {
                writer.writeAttribute("value", (Object)"", null);
            }
            if (selected) {
                if (anyItemSelected != null) {
                    anyItemSelected.set(true);
                }
                writer.writeAttribute("selected", (Object)"selected", null);
            }
            if (disabled = selectItem.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            String labelClass = null;
            labelClass = componentDisabled || disabled ? (String)component.getAttributes().get("disabledClass") : (String)component.getAttributes().get("enabledClass");
            if (labelClass != null) {
                writer.writeAttribute("class", (Object)labelClass, "labelClass");
            }
            if ((escape = AttributeUtils.getBooleanAttribute((UIComponent)component, (String)"escape", (boolean)false)) || selectItem.isEscape()) {
                String label = selectItem.getLabel();
                if (label == null) {
                    label = "";
                }
                writer.writeText((Object)label, null);
            } else {
                writer.write(selectItem.getLabel());
            }
            writer.endElement("option");
            if (!wroteRequestMapVarValue) continue;
            if (oldRequestMapVarValue != null) {
                context.getExternalContext().getRequestMap().put(var, oldRequestMapVarValue);
                continue;
            }
            context.getExternalContext().getRequestMap().remove(var);
        }
    }

    private static boolean isTrue(Object obj) {
        if (obj instanceof String) {
            return Boolean.valueOf((String)obj);
        }
        if (!(obj instanceof Boolean)) {
            return false;
        }
        return (Boolean)obj;
    }
}

