/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jsf.impl.message;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Named;
import org.apache.myfaces.extensions.cdi.jsf.api.Jsf;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.FacesMessageInterpolator;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.JsfAwareApplicationMessagesMessageResolver;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.JsfAwareLocaleResolver;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.JsfAwareMessageHandler;
import org.apache.myfaces.extensions.cdi.jsf.impl.message.MessageHelperMap;
import org.apache.myfaces.extensions.cdi.message.api.LocaleResolver;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageFactory;
import org.apache.myfaces.extensions.cdi.message.api.MessageHandler;
import org.apache.myfaces.extensions.cdi.message.api.MessageInterpolator;
import org.apache.myfaces.extensions.cdi.message.api.MessageResolver;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageContext;
import org.apache.myfaces.extensions.cdi.message.impl.spi.ArgumentFilter;
import org.apache.myfaces.extensions.cdi.message.impl.spi.ELProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class JsfAwareMessageContextProducer {
    @Produces
    @Dependent
    @Jsf
    public MessageContext createContext(MessageContext defaultMessageContext, Instance<MessageFactory> messageFactoryInstance, Instance<ELProvider> elProviderInstance, Instance<ArgumentFilter> argumentFilterInstance) {
        MessageFactory messageFactory = null;
        ELProvider elProvider = null;
        ArgumentFilter argumentFilter = null;
        if (!messageFactoryInstance.isUnsatisfied()) {
            messageFactory = (MessageFactory)messageFactoryInstance.get();
        }
        if (!elProviderInstance.isUnsatisfied()) {
            elProvider = (ELProvider)elProviderInstance.get();
        }
        if (!argumentFilterInstance.isUnsatisfied()) {
            argumentFilter = (ArgumentFilter)argumentFilterInstance.get();
        }
        MessageContext result = defaultMessageContext.config().use().localeResolver((LocaleResolver)new JsfAwareLocaleResolver()).messageResolver((MessageResolver)new JsfAwareApplicationMessagesMessageResolver()).messageInterpolator((MessageInterpolator)new FacesMessageInterpolator(elProvider, argumentFilter)).addMessageHandler((MessageHandler)new JsfAwareMessageHandler()).create();
        if (messageFactory != null) {
            return DefaultMessageContext.create((MessageContextConfig)result.config(), (MessageFactory)messageFactory);
        }
        return result;
    }

    @Produces
    @Dependent
    @Named(value="messageContext")
    public MessageHelperMap createContextForEL(@Jsf MessageContext messageContext) {
        return new MessageHelperMap(messageContext);
    }
}

