/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.config;

import java.util.Collections;
import java.util.List;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.InvocationOrder;
import org.apache.myfaces.extensions.cdi.core.api.config.ConfiguredValueDescriptor;
import org.apache.myfaces.extensions.cdi.core.impl.config.AbstractConfiguredValueResolver;
import org.apache.myfaces.extensions.cdi.core.impl.util.JndiUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
@InvocationOrder(value=300)
public class LocalJndiResolver
extends AbstractConfiguredValueResolver {
    private static final String BASE_NAME = "java:comp/env/myfaces-codi/";

    public <K, T> List<T> resolveInstances(ConfiguredValueDescriptor<K, T> descriptor) {
        String key = descriptor.getKey() instanceof String && ((String)descriptor.getKey()).startsWith("java:comp/env") ? (String)descriptor.getKey() : BASE_NAME + descriptor.getKey();
        Object resolvedValue = null;
        try {
            resolvedValue = JndiUtils.lookup(key, descriptor.getTargetType());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (resolvedValue == null) {
            return Collections.emptyList();
        }
        this.add(resolvedValue);
        return this.getConfiguredValues(descriptor.getTargetType());
    }
}

