/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.activation.ExpressionActivated;
import org.apache.myfaces.extensions.cdi.core.api.interpreter.ExpressionInterpreter;
import org.apache.myfaces.extensions.cdi.core.api.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class ActivationUtils {
    private ActivationUtils() {
    }

    public static boolean isActivated(Class<?> annotatedClass, Class defaultExpressionInterpreterClass) {
        ExpressionInterpreter expressionInterpreter;
        ExpressionActivated expressionActivated = annotatedClass.getAnnotation(ExpressionActivated.class);
        if (expressionActivated == null) {
            return true;
        }
        String expressions = expressionActivated.value();
        Class interpreterClass = expressionActivated.interpreter();
        if (interpreterClass.equals(ExpressionInterpreter.class)) {
            interpreterClass = defaultExpressionInterpreterClass;
        }
        if ((expressionInterpreter = (ExpressionInterpreter)ClassUtils.tryToInstantiateClass((Class)interpreterClass)) == null) {
            Logger logger = Logger.getLogger(ActivationUtils.class.getName());
            if (logger.isLoggable(Level.WARNING)) {
                logger.warning("can't instantiate " + interpreterClass.getClass().getName());
            }
            return true;
        }
        expressions = "configName:" + expressionActivated.configName() + ";" + expressions;
        return (Boolean)expressionInterpreter.evaluate((Object)expressions);
    }
}

