/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.message.impl;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.myfaces.extensions.cdi.message.api.CompositeMessageHandler;
import org.apache.myfaces.extensions.cdi.message.api.Formatter;
import org.apache.myfaces.extensions.cdi.message.api.FormatterFactory;
import org.apache.myfaces.extensions.cdi.message.api.GenericConfig;
import org.apache.myfaces.extensions.cdi.message.api.LocaleResolver;
import org.apache.myfaces.extensions.cdi.message.api.MessageContext;
import org.apache.myfaces.extensions.cdi.message.api.MessageContextConfig;
import org.apache.myfaces.extensions.cdi.message.api.MessageHandler;
import org.apache.myfaces.extensions.cdi.message.api.MessageInterpolator;
import org.apache.myfaces.extensions.cdi.message.api.MessageResolver;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultCompositeMessageHandler;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultFormatterFactory;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultLocaleResolver;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageContext;
import org.apache.myfaces.extensions.cdi.message.impl.DefaultMessageInterpolator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMessageContextConfig
implements MessageContextConfig {
    private static final long serialVersionUID = 2919944628020782545L;
    private MessageInterpolator messageInterpolator;
    private MessageResolver messageResolver;
    private CopyOnWriteArraySet<MessageHandler> messageHandlers;
    private LocaleResolver localeResolver;
    private FormatterFactory formatterFactory;

    DefaultMessageContextConfig() {
        this.resetMessageContextConfig();
    }

    private DefaultMessageContextConfig(MessageContextConfig messageContextConfigTemplate) {
        this();
        this.messageInterpolator = messageContextConfigTemplate.getMessageInterpolator();
        this.messageResolver = messageContextConfigTemplate.getMessageResolver();
        MessageHandler newMessageHandler = messageContextConfigTemplate.getMessageHandler();
        if (newMessageHandler instanceof CompositeMessageHandler) {
            this.messageHandlers.addAll(((CompositeMessageHandler)newMessageHandler).getMessageHandlers());
        } else {
            this.messageHandlers.add(newMessageHandler);
        }
        this.localeResolver = messageContextConfigTemplate.getLocaleResolver();
        this.formatterFactory = messageContextConfigTemplate.getFormatterFactory();
    }

    public MessageContextConfig.MessageContextBuilder use() {
        return new MessageContextConfig.MessageContextBuilder(){
            private DefaultMessageContextConfig newMessageContextConfig;
            {
                this.newMessageContextConfig = new DefaultMessageContextConfig(DefaultMessageContextConfig.this);
            }

            public MessageContextConfig.MessageContextBuilder messageInterpolator(MessageInterpolator messageInterpolator) {
                this.newMessageContextConfig.setMessageInterpolator(messageInterpolator);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder messageResolver(MessageResolver messageResolver) {
                this.newMessageContextConfig.setMessageResolver(messageResolver);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatter(Formatter formatter) {
                this.newMessageContextConfig.addNewFormatter(formatter);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatterConfig(Class<?> type, GenericConfig config) {
                this.newMessageContextConfig.addNewFormatterConfig(type, config, Locale.getDefault());
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatterConfig(Class<?> type, GenericConfig config, Locale locale) {
                DefaultMessageContextConfig.this.addNewFormatterConfig(type, config.addProperty(Locale.class.toString(), (Serializable)locale), locale);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder formatterFactory(FormatterFactory formatterFactory) {
                this.newMessageContextConfig.setFormatterFactory(formatterFactory);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addMessageHandler(MessageHandler messageHandler) {
                this.newMessageContextConfig.addNewMessageHandler(messageHandler);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder localeResolver(LocaleResolver localeResolver) {
                this.newMessageContextConfig.setLocaleResolver(localeResolver);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder reset() {
                this.newMessageContextConfig.resetMessageContextConfig();
                return this;
            }

            public MessageContextConfig.MessageContextBuilder clear() {
                this.newMessageContextConfig.clearMessageContextConfig();
                return this;
            }

            public MessageContext create() {
                return new DefaultMessageContext(this.newMessageContextConfig);
            }
        };
    }

    public MessageContextConfig.MessageContextBuilder change() {
        return new MessageContextConfig.MessageContextBuilder(){

            public MessageContextConfig.MessageContextBuilder messageInterpolator(MessageInterpolator messageInterpolator) {
                DefaultMessageContextConfig.this.setMessageInterpolator(messageInterpolator);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder messageResolver(MessageResolver messageResolver) {
                DefaultMessageContextConfig.this.setMessageResolver(messageResolver);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatter(Formatter formatter) {
                DefaultMessageContextConfig.this.addNewFormatter(formatter);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatterConfig(Class<?> type, GenericConfig config) {
                DefaultMessageContextConfig.this.addNewFormatterConfig(type, config, Locale.getDefault());
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addFormatterConfig(Class<?> type, GenericConfig config, Locale locale) {
                DefaultMessageContextConfig.this.addNewFormatterConfig(type, config.addProperty(Locale.class.toString(), (Serializable)locale), locale);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder formatterFactory(FormatterFactory formatterFactory) {
                DefaultMessageContextConfig.this.setFormatterFactory(formatterFactory);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder addMessageHandler(MessageHandler messageHandler) {
                DefaultMessageContextConfig.this.addNewMessageHandler(messageHandler);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder localeResolver(LocaleResolver localeResolver) {
                DefaultMessageContextConfig.this.setLocaleResolver(localeResolver);
                return this;
            }

            public MessageContextConfig.MessageContextBuilder reset() {
                DefaultMessageContextConfig.this.resetMessageContextConfig();
                return this;
            }

            public MessageContextConfig.MessageContextBuilder clear() {
                DefaultMessageContextConfig.this.clearMessageContextConfig();
                return this;
            }

            public MessageContext create() {
                return new DefaultMessageContext(DefaultMessageContextConfig.this);
            }
        };
    }

    private void resetMessageContextConfig() {
        this.messageInterpolator = new DefaultMessageInterpolator();
        this.messageResolver = null;
        this.messageHandlers = new CopyOnWriteArraySet();
        this.localeResolver = new DefaultLocaleResolver();
        this.formatterFactory = new DefaultFormatterFactory();
    }

    private void clearMessageContextConfig() {
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageInterpolator;
    }

    public MessageResolver getMessageResolver() {
        return this.messageResolver;
    }

    public LocaleResolver getLocaleResolver() {
        return this.localeResolver;
    }

    public MessageHandler getMessageHandler() {
        return new DefaultCompositeMessageHandler(this.messageHandlers);
    }

    public FormatterFactory getFormatterFactory() {
        return this.formatterFactory;
    }

    private void setMessageInterpolator(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    private void setMessageResolver(MessageResolver messageResolver) {
        this.messageResolver = messageResolver;
    }

    private void addNewFormatter(Formatter formatter) {
        this.formatterFactory.add((Object)formatter);
    }

    private void addNewFormatterConfig(Class<?> type, GenericConfig config, Locale locale) {
        this.formatterFactory.addFormatterConfig(type, config, locale);
    }

    private void addNewMessageHandler(MessageHandler messageHandler) {
        this.messageHandlers.add(messageHandler);
    }

    private void setLocaleResolver(LocaleResolver localeResolver) {
        this.localeResolver = localeResolver;
    }

    private void setFormatterFactory(FormatterFactory formatterFactory) {
        this.formatterFactory = formatterFactory;
    }

    public String toString() {
        String newLine = System.getProperty("line.separator");
        StringBuilder configInfo = new StringBuilder("MessageContextConfig class: ");
        configInfo.append(this.getClass().getName());
        configInfo.append(newLine);
        if (this.messageInterpolator != null) {
            configInfo.append("   MessageInterpolator class: ").append(this.messageInterpolator.getClass());
        } else {
            configInfo.append("   no MessageInterpolator");
        }
        configInfo.append(newLine);
        if (this.messageResolver != null) {
            configInfo.append("   MessageResolver class: ").append(this.messageResolver.getClass());
        } else {
            configInfo.append("   no MessageResolver");
        }
        configInfo.append(newLine);
        if (this.messageHandlers != null && !this.messageHandlers.isEmpty()) {
            for (MessageHandler messageHandler : this.messageHandlers) {
                configInfo.append("   MessageHandler class: ").append(messageHandler.getClass());
            }
        } else {
            configInfo.append("   no MessageHandlers");
        }
        configInfo.append(newLine);
        if (this.localeResolver != null) {
            configInfo.append("   LocaleResolver class: ").append(this.localeResolver.getClass());
        } else {
            configInfo.append("   no LocaleResolver");
        }
        configInfo.append(newLine);
        if (this.formatterFactory != null) {
            configInfo.append("   FormatterFactory class: ").append(this.formatterFactory.getClass());
            configInfo.append(newLine);
        } else {
            configInfo.append("   no FormatterFactory");
        }
        return configInfo.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultMessageContextConfig)) {
            return false;
        }
        DefaultMessageContextConfig that = (DefaultMessageContextConfig)o;
        if (!this.formatterFactory.equals(that.formatterFactory)) {
            return false;
        }
        if (!this.localeResolver.equals(that.localeResolver)) {
            return false;
        }
        if (!this.messageHandlers.equals(that.messageHandlers)) {
            return false;
        }
        if (this.messageInterpolator != null ? !this.messageInterpolator.equals(that.messageInterpolator) : that.messageInterpolator != null) {
            return false;
        }
        return !(this.messageResolver != null ? !this.messageResolver.equals(that.messageResolver) : that.messageResolver != null);
    }

    public int hashCode() {
        int result = this.messageInterpolator != null ? this.messageInterpolator.hashCode() : 0;
        result = 31 * result + (this.messageResolver != null ? this.messageResolver.hashCode() : 0);
        result = 31 * result + this.messageHandlers.hashCode();
        result = 31 * result + this.localeResolver.hashCode();
        result = 31 * result + this.formatterFactory.hashCode();
        return result;
    }
}

