/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.interceptor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.el.PropertyNotFoundException;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.validator.ValidatorException;
import org.apache.myfaces.extensions.validator.core.ExtValContext;
import org.apache.myfaces.extensions.validator.core.ExtValCoreConfiguration;
import org.apache.myfaces.extensions.validator.core.ValidationModuleKey;
import org.apache.myfaces.extensions.validator.core.el.ELHelper;
import org.apache.myfaces.extensions.validator.core.interceptor.AbstractRendererInterceptor;
import org.apache.myfaces.extensions.validator.core.metadata.extractor.MetaDataExtractor;
import org.apache.myfaces.extensions.validator.core.property.PropertyInformation;
import org.apache.myfaces.extensions.validator.core.recorder.ProcessedInformationRecorder;
import org.apache.myfaces.extensions.validator.core.renderkit.RendererProxy;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipAfterInterceptorsException;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipBeforeInterceptorsException;
import org.apache.myfaces.extensions.validator.core.renderkit.exception.SkipRendererDelegationException;
import org.apache.myfaces.extensions.validator.core.storage.RendererInterceptorPropertyStorage;
import org.apache.myfaces.extensions.validator.internal.UsageCategory;
import org.apache.myfaces.extensions.validator.internal.UsageInformation;
import org.apache.myfaces.extensions.validator.util.ExtValUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@UsageInformation(value={UsageCategory.REUSE})
public abstract class AbstractValidationInterceptor
extends AbstractRendererInterceptor {
    private ELHelper elHelper;

    protected boolean isRequiredInitializationSupported() {
        return false;
    }

    @Override
    public void afterDecode(FacesContext facesContext, UIComponent uiComponent, Renderer wrapped) throws SkipAfterInterceptorsException {
        if (uiComponent instanceof EditableValueHolder && ExtValUtils.isRequiredResetActivated() && this.isRequiredInitializationSupported() && ExtValUtils.isRequiredInitializationActive()) {
            ((EditableValueHolder)uiComponent).setRequired(false);
        }
    }

    @Override
    public void beforeEncodeBegin(FacesContext facesContext, UIComponent uiComponent, Renderer wrapped) throws IOException, SkipBeforeInterceptorsException, SkipRendererDelegationException {
        if (this.processComponent(uiComponent) && !this.isComponentInitializationDeactivated()) {
            this.initComponent(facesContext, uiComponent);
        }
    }

    protected abstract void initComponent(FacesContext var1, UIComponent var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeGetConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object o, Renderer wrapped) throws ConverterException, SkipBeforeInterceptorsException, SkipRendererDelegationException {
        Object convertedObject;
        if (Boolean.TRUE.equals(facesContext.getExternalContext().getRequestMap().get("skip_validation"))) {
            return;
        }
        try {
            convertedObject = wrapped instanceof RendererProxy ? ((RendererProxy)wrapped).getCachedConvertedValue(facesContext, uiComponent, o) : wrapped.getConvertedValue(facesContext, uiComponent, o);
        }
        catch (PropertyNotFoundException r) {
            this.logger.log(Level.SEVERE, "it seems you are using an invalid binding. " + wrapped.getClass().getName() + ": conversion failed. normally this is >not< a myfaces extval issue!", r);
            throw r;
        }
        this.setRendererInterceptorProperties(uiComponent);
        if (this.recordProcessedInformation()) {
            for (ProcessedInformationRecorder recorder : ExtValContext.getContext().getProcessedInformationRecorders()) {
                recorder.recordUserInput(uiComponent, convertedObject);
                this.logger.finest(recorder.getClass().getName() + " called");
            }
        }
        boolean validateValue = false;
        try {
            if (this.processComponent(uiComponent) && (validateValue = this.validateValue(convertedObject = this.transformValueForValidation(convertedObject))) && this.processBeforeValidation(facesContext, uiComponent, convertedObject)) {
                this.processValidation(facesContext, uiComponent, convertedObject);
            }
        }
        catch (ValidatorException e) {
            try {
                ExtValUtils.tryToThrowValidatorExceptionForComponent(uiComponent, e.getFacesMessage(), e);
            }
            catch (ValidatorException finalException) {
                throw new ConverterException(e.getFacesMessage(), (Throwable)e);
            }
        }
        finally {
            if (validateValue) {
                this.processAfterValidation(facesContext, uiComponent, convertedObject);
            }
            this.resetRendererInterceptorProperties(uiComponent);
        }
    }

    protected boolean processBeforeValidation(FacesContext facesContext, UIComponent uiComponent, Object value) {
        return ExtValUtils.executeGlobalBeforeValidationInterceptors(facesContext, uiComponent, value, PropertyInformation.class.getName(), this.getPropertyInformation(facesContext, uiComponent), this.getModuleKey());
    }

    protected void processAfterValidation(FacesContext facesContext, UIComponent uiComponent, Object value) {
        ExtValUtils.executeGlobalAfterValidationInterceptors(facesContext, uiComponent, value, PropertyInformation.class.getName(), this.getPropertyInformation(facesContext, uiComponent), this.getModuleKey());
    }

    protected PropertyInformation getPropertyInformation(FacesContext facesContext, UIComponent uiComponent) {
        Map<String, Object> properties = this.getPropertiesForComponentMetaDataExtractor(uiComponent);
        MetaDataExtractor metaDataExtractor = this.getComponentMetaDataExtractor(properties);
        return metaDataExtractor.extract(facesContext, uiComponent);
    }

    protected abstract MetaDataExtractor getComponentMetaDataExtractor(Map<String, Object> var1);

    protected Object transformValueForValidation(Object convertedObject) {
        if ("".equals(convertedObject) && this.interpretEmptyStringValuesAsNull()) {
            return null;
        }
        return convertedObject;
    }

    protected boolean validateValue(Object convertedObject) {
        if (this.isValueToValidateEmpty(convertedObject) && !this.validateEmptyFields()) {
            this.logger.fine("empty field validation is deactivated in the web.xml - see: javax.faces.VALIDATE_EMPTY_FIELDS");
            return false;
        }
        return true;
    }

    protected boolean isValueToValidateEmpty(Object convertedObject) {
        return convertedObject == null || "".equals(convertedObject);
    }

    protected boolean validateEmptyFields() {
        return ExtValUtils.validateEmptyFields();
    }

    protected boolean interpretEmptyStringValuesAsNull() {
        return ExtValUtils.interpretEmptyStringValuesAsNull();
    }

    protected abstract void processValidation(FacesContext var1, UIComponent var2, Object var3);

    protected boolean processComponent(UIComponent uiComponent) {
        return uiComponent instanceof EditableValueHolder && this.isValueBindingOfComponentValid(uiComponent);
    }

    protected ELHelper getELHelper() {
        if (this.elHelper == null) {
            this.elHelper = ExtValUtils.getELHelper();
        }
        return this.elHelper;
    }

    private boolean isValueBindingOfComponentValid(UIComponent uiComponent) {
        try {
            return this.getELHelper().getPropertyDetailsOfValueBinding(uiComponent) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isComponentInitializationDeactivated() {
        return ExtValCoreConfiguration.get().deactivateComponentInitialization();
    }

    protected boolean recordProcessedInformation() {
        return false;
    }

    protected Class getModuleKey() {
        return null;
    }

    protected Map<String, Object> getPropertiesForComponentMetaDataExtractor(UIComponent uiComponent) {
        return this.createProperties(uiComponent);
    }

    protected Map<String, Object> getInterceptorProperties(UIComponent uiComponent) {
        return this.createProperties(uiComponent);
    }

    private Map<String, Object> createProperties(UIComponent uiComponent) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.getModuleKey() != null) {
            result.put(ValidationModuleKey.class.getName(), this.getModuleKey());
        }
        result.put(UIComponent.class.getName(), uiComponent);
        return result;
    }

    private void setRendererInterceptorProperties(UIComponent uiComponent) {
        RendererInterceptorPropertyStorage interceptorPropertyStorage = this.getRendererInterceptorPropertyStorage();
        Map<String, Object> properties = this.getInterceptorProperties(uiComponent);
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            interceptorPropertyStorage.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private void resetRendererInterceptorProperties(UIComponent uiComponent) {
        RendererInterceptorPropertyStorage interceptorPropertyStorage = this.getRendererInterceptorPropertyStorage();
        for (String key : this.getInterceptorProperties(uiComponent).keySet()) {
            interceptorPropertyStorage.removeProperty(key);
        }
    }

    private RendererInterceptorPropertyStorage getRendererInterceptorPropertyStorage() {
        return ExtValUtils.getStorage(RendererInterceptorPropertyStorage.class, RendererInterceptorPropertyStorage.class.getName());
    }
}

