/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.metadata.model.api.support.annotation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jpt30.lang.model.element.AnnotationMirror;
import jpt30.lang.model.element.TypeElement;
import jpt30.lang.model.type.DeclaredType;
import jpt30.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClassIndexListener;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.RootsEvent;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TypesEvent;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationScanner;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.JavaContextListener;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.ObjectProvider;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObject;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.WeakSet;

public final class AnnotationModelHelper {
    private final ClasspathInfo cpi;
    private final Set<JavaContextListener> javaContextListeners = new WeakSet<JavaContextListener>();
    private final Set<PersistentObjectManager<? extends PersistentObject>> managers = new WeakSet<PersistentObjectManager<? extends PersistentObject>>();
    private ClassIndex classIndex;
    private ClassIndexListenerImpl listener;
    JavaSource javaSource;
    private Thread userActionTaskThread;
    private AnnotationScanner annotationScanner;
    private CompilationController controller;
    private AnnotationHelper helper;

    public static AnnotationModelHelper create(ClasspathInfo cpi) {
        return new AnnotationModelHelper(cpi);
    }

    private AnnotationModelHelper(ClasspathInfo cpi) {
        this.cpi = cpi;
        this.helper = new AnnotationHelper(this);
    }

    public ClasspathInfo getClasspathInfo() {
        return this.cpi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends PersistentObject> PersistentObjectManager<T> createPersistentObjectManager(ObjectProvider<T> provider) {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            PersistentObjectManager<T> manager = PersistentObjectManager.create(this, provider);
            this.registerPersistentObjectManager(manager);
            return manager;
        }
    }

    private void registerPersistentObjectManager(PersistentObjectManager<? extends PersistentObject> manager) {
        assert (Thread.holdsLock(this));
        if (this.classIndex == null) {
            this.classIndex = this.cpi.getClassIndex();
            this.listener = new ClassIndexListenerImpl();
            this.classIndex.addClassIndexListener(this.listener);
        }
        this.managers.add(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaContextListener(JavaContextListener listener) {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            this.javaContextListeners.add(listener);
        }
    }

    public <V> V runJavaSourceTask(Callable<V> callable) throws IOException {
        return this.runJavaSourceTask(callable, true);
    }

    public void runJavaSourceTask(final Runnable run) throws IOException {
        this.runJavaSourceTask(new Callable<Void>(){

            @Override
            public Void call() {
                run.run();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V> V runJavaSourceTask(final Callable<V> callable, final boolean notify) throws IOException {
        JavaSource existingJavaSource;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            existingJavaSource = this.javaSource;
        }
        JavaSource newJavaSource = existingJavaSource != null ? existingJavaSource : JavaSource.create(this.cpi, new FileObject[0]);
        final ArrayList result = new ArrayList();
        try {
            newJavaSource.runUserActionTask((Task<CompilationController>)new CancellableTask<CompilationController>(){

                @Override
                public void run(CompilationController controller) throws Exception {
                    result.add(AnnotationModelHelper.this.runCallable(callable, controller, notify));
                }

                @Override
                public void cancel() {
                }
            }, true);
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MetadataModelException) {
                throw (MetadataModelException)cause;
            }
            throw e;
        }
        return (V)result.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Future<V> runJavaSourceTaskWhenScanFinished(final Callable<V> callable) throws IOException {
        JavaSource existingJavaSource;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            existingJavaSource = this.javaSource;
        }
        JavaSource newJavaSource = existingJavaSource != null ? existingJavaSource : JavaSource.create(this.cpi, new FileObject[0]);
        final DelegatingFuture result = new DelegatingFuture();
        try {
            result.setDelegate(newJavaSource.runWhenScanFinished((Task<CompilationController>)new CancellableTask<CompilationController>(){

                @Override
                public void run(CompilationController controller) throws Exception {
                    result.setResult(AnnotationModelHelper.this.runCallable(callable, controller, true));
                }

                @Override
                public void cancel() {
                }
            }, true));
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            if (cause instanceof MetadataModelException) {
                throw (MetadataModelException)cause;
            }
            throw e;
        }
        assert (result.delegate != null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V runCallable(Callable<V> callable, CompilationController controller, boolean notify) throws IOException {
        JavaSource oldJavaSource;
        Thread oldUserActionTaskThread;
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            if (this.userActionTaskThread != null && this.userActionTaskThread != Thread.currentThread()) {
                throw new IllegalStateException("JavaSource.runUserActionTask() should not be executed by multiple threads concurrently");
            }
            oldUserActionTaskThread = this.userActionTaskThread;
            this.userActionTaskThread = Thread.currentThread();
            oldJavaSource = this.javaSource;
            this.javaSource = controller.getJavaSource();
        }
        CompilationController oldController = this.controller;
        this.controller = controller;
        try {
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            V v = callable.call();
            return v;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new MetadataModelException(e);
        }
        finally {
            this.controller = oldController;
            this.annotationScanner = null;
            AnnotationModelHelper annotationModelHelper2 = this;
            synchronized (annotationModelHelper2) {
                this.javaSource = oldJavaSource;
                this.userActionTaskThread = oldUserActionTaskThread;
            }
            if (notify) {
                for (JavaContextListener hook : this.javaContextListeners) {
                    hook.javaContextLeft();
                }
            }
        }
    }

    public CompilationController getCompilationController() {
        this.assertUserActionTaskThread();
        assert (this.controller != null);
        return this.controller;
    }

    public AnnotationScanner getAnnotationScanner() {
        this.assertUserActionTaskThread();
        if (this.annotationScanner == null) {
            this.annotationScanner = new AnnotationScanner(this.getHelper());
        }
        return this.annotationScanner;
    }

    public AnnotationHelper getHelper() {
        return this.helper;
    }

    public boolean isJavaScanInProgress() {
        return SourceUtils.isScanInProgress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUserActionTaskThread() {
        AnnotationModelHelper annotationModelHelper = this;
        synchronized (annotationModelHelper) {
            if (this.userActionTaskThread != Thread.currentThread()) {
                throw new IllegalStateException("The current thread is not running userActionTask()");
            }
        }
    }

    public TypeMirror resolveType(String typeName) {
        this.assertUserActionTaskThread();
        return this.getHelper().resolveType(typeName);
    }

    public boolean isSameRawType(TypeMirror type1, String type2ElementName) {
        this.assertUserActionTaskThread();
        return this.getHelper().isSameRawType(type1, type2ElementName);
    }

    public List<? extends TypeElement> getSuperclasses(TypeElement type) {
        this.assertUserActionTaskThread();
        return this.getHelper().getSuperclasses(type);
    }

    public TypeElement getSuperclass(TypeElement type) {
        this.assertUserActionTaskThread();
        return this.getHelper().getSuperclass(type);
    }

    public boolean hasAnnotation(List<? extends AnnotationMirror> annotations, String annotationTypeName) {
        this.assertUserActionTaskThread();
        return this.getHelper().hasAnnotation(annotations, annotationTypeName);
    }

    public boolean hasAnyAnnotation(List<? extends AnnotationMirror> annotations, Set<String> annotationTypeNames) {
        this.assertUserActionTaskThread();
        return this.getHelper().hasAnyAnnotation(annotations, annotationTypeNames);
    }

    public Map<String, ? extends AnnotationMirror> getAnnotationsByType(List<? extends AnnotationMirror> annotations) {
        this.assertUserActionTaskThread();
        return this.getHelper().getAnnotationsByType(annotations);
    }

    public String getAnnotationTypeName(DeclaredType typeMirror) {
        this.assertUserActionTaskThread();
        return this.getHelper().getAnnotationTypeName(typeMirror);
    }

    private static final class DelegatingFuture<V>
    implements Future<V> {
        private volatile Future<Void> delegate;
        private volatile V result;

        private DelegatingFuture() {
        }

        public void setDelegate(Future<Void> delegate) {
            assert (this.delegate == null);
            this.delegate = delegate;
        }

        public void setResult(V result) {
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            this.delegate.get();
            return this.result;
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.delegate.get(timeout, unit);
            return this.result;
        }
    }

    private final class ClassIndexListenerImpl
    implements ClassIndexListener {
        private ClassIndexListenerImpl() {
        }

        @Override
        public void typesAdded(final TypesEvent event) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager manager : AnnotationModelHelper.this.managers) {
                            manager.typesAdded(event.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
        }

        @Override
        public void typesRemoved(final TypesEvent event) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager manager : AnnotationModelHelper.this.managers) {
                            manager.typesRemoved(event.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
        }

        @Override
        public void typesChanged(final TypesEvent event) {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager manager : AnnotationModelHelper.this.managers) {
                            manager.typesChanged(event.getTypes());
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
        }

        @Override
        public void rootsAdded(RootsEvent event) {
            this.rootsChanged();
        }

        @Override
        public void rootsRemoved(RootsEvent event) {
            this.rootsChanged();
        }

        private void rootsChanged() {
            try {
                this.runInJavacContext(new Callable<Void>(){

                    @Override
                    public Void call() {
                        for (PersistentObjectManager manager : AnnotationModelHelper.this.managers) {
                            manager.rootsChanged();
                        }
                        return null;
                    }
                });
            }
            catch (IOException e) {
                Exceptions.printStackTrace(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <V> void runInJavacContext(Callable<V> call) throws IOException {
            AnnotationModelHelper annotationModelHelper = AnnotationModelHelper.this;
            synchronized (annotationModelHelper) {
                if (AnnotationModelHelper.this.userActionTaskThread == Thread.currentThread()) {
                    throw new IllegalStateException("Retouche is sending ClassIndex events from within JavaSource.runUserActionTask()");
                }
            }
            AnnotationModelHelper.this.runJavaSourceTask(call, false);
        }
    }
}

