/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MultiModuleSourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation2,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MultiModuleSourceForBinaryQueryImpl.class.getName());
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final MultiModule modules;
    private final MultiModule testModules;
    private final String[] binaryProperties;
    private final String[] testBinaryProperties;
    private final Map<URI, R> cache;

    MultiModuleSourceForBinaryQueryImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator eval, @NonNull MultiModule modules, @NonNull MultiModule testModules, @NonNull String[] binaryProperties, @NonNull String[] testBinaryProperties) {
        Parameters.notNull("helper", helper);
        Parameters.notNull("eval", eval);
        Parameters.notNull("modules", modules);
        Parameters.notNull("testModules", testModules);
        Parameters.notNull("binaryProperties", binaryProperties);
        Parameters.notNull("testBinaryProperties", testBinaryProperties);
        this.helper = helper;
        this.eval = eval;
        this.modules = modules;
        this.testModules = testModules;
        this.binaryProperties = binaryProperties;
        this.testBinaryProperties = testBinaryProperties;
        this.cache = new ConcurrentHashMap<URI, R>();
        this.eval.addPropertyChangeListener(WeakListeners.propertyChange(this, this.eval));
        this.modules.addPropertyChangeListener(WeakListeners.propertyChange(this, this.modules));
        this.testModules.addPropertyChangeListener(WeakListeners.propertyChange(this, this.testModules));
    }

    @Override
    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(@NonNull URL binaryRoot) {
        boolean archive = false;
        if (FileUtil.isArchiveArtifact(binaryRoot)) {
            binaryRoot = FileUtil.getArchiveFile(binaryRoot);
            archive = true;
        }
        R res = null;
        try {
            URI artefact = binaryRoot.toURI();
            res = this.cache.get(artefact);
            if (res == null) {
                R prev;
                res = this.createResult(artefact, archive, this.modules, this.binaryProperties);
                if (res == null) {
                    res = this.createResult(artefact, archive, this.testModules, this.testBinaryProperties);
                }
                if ((prev = this.cache.get(artefact)) != null) {
                    res = prev;
                } else if (res != null && (prev = this.cache.putIfAbsent(artefact, res)) != null) {
                    res = prev;
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Invalid URI: {0}", binaryRoot.toExternalForm());
        }
        return res;
    }

    @Override
    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block4: {
            String propName;
            block5: {
                Object source;
                block3: {
                    source = evt.getSource();
                    propName = evt.getPropertyName();
                    if (source != this.modules) break block3;
                    Collection<? extends String> moduleNames = this.modules.getModuleNames();
                    Iterator<Map.Entry<URI, R>> it = this.cache.entrySet().iterator();
                    while (it.hasNext()) {
                        R r = it.next().getValue();
                        if (!MultiModuleSourceForBinaryQueryImpl.contains(r.getProperty(), this.binaryProperties) || moduleNames.contains(r.getModuleName())) continue;
                        it.remove();
                    }
                    break block4;
                }
                if (source != this.testModules) break block5;
                Collection<? extends String> moduleNames = this.testModules.getModuleNames();
                Iterator<Map.Entry<URI, R>> it = this.cache.entrySet().iterator();
                while (it.hasNext()) {
                    R r = it.next().getValue();
                    if (!MultiModuleSourceForBinaryQueryImpl.contains(r.getProperty(), this.testBinaryProperties) || moduleNames.contains(r.getModuleName())) continue;
                    it.remove();
                }
                break block4;
            }
            if (!MultiModuleSourceForBinaryQueryImpl.contains(propName, this.binaryProperties) && !MultiModuleSourceForBinaryQueryImpl.contains(propName, this.testBinaryProperties)) break block4;
            Iterator<Map.Entry<URI, R>> it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<URI, R> e = it.next();
                URI uri = e.getKey();
                R r = e.getValue();
                if (!propName.equals(r.getProperty()) || MultiModuleSourceForBinaryQueryImpl.getOwner(this.eval, this.helper, uri, new String[]{propName}) != null) continue;
                it.remove();
            }
        }
    }

    private static boolean contains(@NullAllowed String prop, @NonNull String[] props) {
        for (String p : props) {
            if (!p.equals(prop)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private R createResult(@NonNull URI artefact, boolean archive, @NonNull MultiModule modules, String ... properties) {
        ClassPath cp;
        String moduleName;
        String prop = MultiModuleSourceForBinaryQueryImpl.getOwner(this.eval, this.helper, artefact, properties);
        if (prop != null && (moduleName = MultiModuleSourceForBinaryQueryImpl.getModuleName(artefact, archive)) != null && (cp = modules.getModuleSources(moduleName)) != null) {
            return new R(artefact, cp, this.eval, this.helper, moduleName, prop);
        }
        return null;
    }

    @CheckForNull
    private static String getOwner(@NonNull PropertyEvaluator eval, @NonNull AntProjectHelper helper, @NonNull URI artefact, @NonNull String[] properties) {
        return Arrays.stream(properties).map(prop -> {
            String val = eval.getProperty((String)prop);
            return val == null ? null : Pair.of(prop, val);
        }).filter(propPathPair -> propPathPair != null).map(propPathPair -> {
            try {
                File f = helper.resolveFile((String)propPathPair.second());
                URI uri = BaseUtilities.toURI(f);
                String suri = uri.toString();
                if (!suri.endsWith("/")) {
                    uri = new URI(suri + '/');
                }
                return Pair.of((String)propPathPair.first(), uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).filter(propFolderURIPair -> propFolderURIPair != null && artefact.toString().startsWith(((URI)propFolderURIPair.second()).toString())).map(propFolderURIPair -> (String)propFolderURIPair.first()).findAny().orElse(null);
    }

    @CheckForNull
    private static String getModuleName(@NonNull URI uri, boolean archive) {
        Path p = Paths.get(uri);
        if (p == null) {
            return null;
        }
        String nameExt = p.getFileName().toString();
        int dot = nameExt.lastIndexOf(46);
        if (dot < 0 || !archive) {
            return nameExt;
        }
        if (dot == 0) {
            return null;
        }
        return nameExt.substring(0, dot);
    }

    private static final class R
    implements SourceForBinaryQueryImplementation2.Result,
    PropertyChangeListener {
        private static final FileObject[] EMPTY = new FileObject[0];
        private final URI artefact;
        private final ClassPath srcPath;
        private final PropertyEvaluator eval;
        private final AntProjectHelper helper;
        private final String moduleName;
        private final String prop;
        private final ChangeSupport listeners;
        private volatile int state;

        R(@NonNull URI artefact, @NonNull ClassPath srcPath, @NonNull PropertyEvaluator eval, @NonNull AntProjectHelper helper, @NonNull String moduleName, @NonNull String prop) {
            Parameters.notNull("artefact", artefact);
            Parameters.notNull("srcPath", srcPath);
            Parameters.notNull("eval", eval);
            Parameters.notNull("helper", helper);
            Parameters.notNull("moduleName", moduleName);
            Parameters.notNull("prop", prop);
            this.artefact = artefact;
            this.srcPath = srcPath;
            this.eval = eval;
            this.helper = helper;
            this.moduleName = moduleName;
            this.prop = prop;
            this.listeners = new ChangeSupport(this);
            this.srcPath.addPropertyChangeListener(WeakListeners.propertyChange(this, this.srcPath));
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange(this, this.eval));
        }

        @Override
        public boolean preferSources() {
            return true;
        }

        @Override
        public FileObject[] getRoots() {
            int st = this.state;
            if (st == 1) {
                this.state = MultiModuleSourceForBinaryQueryImpl.getOwner(this.eval, this.helper, this.artefact, new String[]{this.prop}) != null ? 0 : 2;
                st = this.state;
            }
            return st == 0 ? this.srcPath.getRoots() : EMPTY;
        }

        @Override
        public void addChangeListener(@NonNull ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        @Override
        public void removeChangeListener(@NonNull ChangeListener l) {
            this.listeners.removeChangeListener(l);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt.getPropertyName();
            if ("roots".equals(propName)) {
                this.listeners.fireChange();
            } else if (this.prop.equals(propName) || propName == null) {
                this.state = 1;
                this.listeners.fireChange();
            }
        }

        String getProperty() {
            return this.prop;
        }

        String getModuleName() {
            return this.moduleName;
        }
    }
}

