/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.logging.buffered;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.flywaydb.core.api.logging.Log;

public class BufferedLog
implements Log {
    public final List<BufferedLogMessage> bufferedLogMessages = Collections.synchronizedList(new ArrayList());

    @Override
    public boolean isDebugEnabled() {
        return true;
    }

    @Override
    public void debug(String message) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.DEBUG));
    }

    @Override
    public void info(String message) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.INFO));
    }

    @Override
    public void warn(String message) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.WARN));
    }

    @Override
    public void error(String message) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.ERROR));
    }

    @Override
    public void error(String message, Exception e) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.ERROR, e));
    }

    @Override
    public void notice(String message) {
        this.bufferedLogMessages.add(new BufferedLogMessage(message, Level.NOTICE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(Log target) {
        List<BufferedLogMessage> list = this.bufferedLogMessages;
        synchronized (list) {
            for (BufferedLogMessage message : this.bufferedLogMessages) {
                switch (message.level) {
                    case DEBUG: {
                        target.debug(message.message);
                        break;
                    }
                    case INFO: {
                        target.info(message.message);
                        break;
                    }
                    case WARN: {
                        target.warn(message.message);
                        break;
                    }
                    case NOTICE: {
                        target.notice(message.message);
                        break;
                    }
                    case ERROR: {
                        if (message.e == null) {
                            target.error(message.message);
                            break;
                        }
                        target.error(message.message, message.e);
                    }
                }
            }
            this.bufferedLogMessages.clear();
        }
    }

    public static enum Level {
        DEBUG,
        INFO,
        WARN,
        ERROR,
        NOTICE;

    }

    public static class BufferedLogMessage {
        public final String message;
        public final Level level;
        public final Exception e;

        public BufferedLogMessage(String message, Level level) {
            this(message, level, null);
        }

        public BufferedLogMessage(String message, Level level, Exception e) {
            this.message = message;
            this.level = level;
            this.e = e;
        }
    }
}

