/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.registry.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.cli.ParseException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.BundleVersionClient;
import org.apache.nifi.registry.client.NiFiRegistryClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.extension.bundle.BundleType;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.toolkit.cli.api.Context;
import org.apache.nifi.toolkit.cli.impl.command.CommandOption;
import org.apache.nifi.toolkit.cli.impl.command.registry.AbstractNiFiRegistryCommand;
import org.apache.nifi.toolkit.cli.impl.result.StringResult;

public class UploadBundles
extends AbstractNiFiRegistryCommand<StringResult> {
    public UploadBundles() {
        super("upload-bundles", StringResult.class);
    }

    @Override
    public String getDescription() {
        return "Performs a bulk upload of multiple bundles to the specified bucket in the registry. This command will look for files in the specified directory, and if recurse (-r) is specified then it will search child directories recursively. If fileExtension is specified then it will only consider files that have the specified extension, such as '.nar'";
    }

    @Override
    public void doInitialize(Context context) {
        this.addOption(CommandOption.BUCKET_ID.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_TYPE.createOption());
        this.addOption(CommandOption.EXT_BUNDLE_DIR.createOption());
        this.addOption(CommandOption.FILE_EXTENSION.createOption());
        this.addOption(CommandOption.RECURSIVE.createOption());
        this.addOption(CommandOption.SKIP_SHA_256.createOption());
    }

    @Override
    public StringResult doExecute(NiFiRegistryClient client, Properties properties) throws IOException, NiFiRegistryException, ParseException {
        BundleType bundleType;
        String bucketId = this.getRequiredArg(properties, CommandOption.BUCKET_ID);
        String bundleDir = this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_DIR);
        String fileExtension = this.getArg(properties, CommandOption.FILE_EXTENSION);
        boolean recursive = properties.containsKey(CommandOption.RECURSIVE.getLongName());
        boolean skipSha256 = properties.containsKey(CommandOption.SKIP_SHA_256.getLongName());
        boolean verbose = this.isVerbose(properties);
        try {
            bundleType = BundleType.fromString((String)this.getRequiredArg(properties, CommandOption.EXT_BUNDLE_TYPE));
        }
        catch (IllegalArgumentException e) {
            throw new NiFiRegistryException("Invalid bundle type, should be one of " + BundleType.NIFI_NAR.toString() + " or " + BundleType.MINIFI_CPP.toString());
        }
        BundleVersionClient bundleVersionClient = client.getBundleVersionClient();
        File startDir = new File(bundleDir);
        if (!startDir.exists()) {
            throw new NiFiRegistryException("The specified directory does not exist: " + startDir.getAbsolutePath());
        }
        if (!startDir.isDirectory()) {
            throw new NiFiRegistryException("The specified directory is not a directory: " + startDir.getAbsolutePath());
        }
        AtomicInteger counter = new AtomicInteger(0);
        this.uploadBundle(bundleVersionClient, bucketId, bundleType, startDir, fileExtension, recursive, skipSha256, verbose, counter);
        return new StringResult("Uploaded " + counter.get() + " bundles successfully", this.getContext().isInteractive());
    }

    private void uploadBundle(BundleVersionClient bundleVersionClient, String bucketId, BundleType bundleType, File directory, String fileExtension, boolean recurse, boolean skipSha256, boolean verbose, AtomicInteger counter) {
        for (File file : directory.listFiles()) {
            if (file.isDirectory() && recurse) {
                this.uploadBundle(bundleVersionClient, bucketId, bundleType, file, fileExtension, recurse, skipSha256, verbose, counter);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)fileExtension) && !file.getName().endsWith(fileExtension)) continue;
            String sha256 = null;
            if (!skipSha256 && (sha256 = this.calculateSha256(file, verbose)) == null) continue;
            try (FileInputStream bundleInputStream = new FileInputStream(file);){
                BundleVersion createdVersion = bundleVersionClient.create(bucketId, bundleType, (InputStream)bundleInputStream, sha256);
                counter.incrementAndGet();
                if (!this.getContext().isInteractive()) continue;
                this.println("Successfully uploaded " + createdVersion.getBundle().getGroupId() + "::" + createdVersion.getBundle().getArtifactId() + "::" + createdVersion.getVersionMetadata().getVersion());
            }
            catch (Exception e) {
                this.println("Error uploading bundle from " + file.getAbsolutePath());
                if (!verbose) continue;
                e.printStackTrace(this.getContext().getOutput());
            }
        }
    }

    private String calculateSha256(File file, boolean verbose) {
        String string;
        FileInputStream inputStream = new FileInputStream(file);
        try {
            string = Hex.encodeHexString((byte[])DigestUtils.sha256((InputStream)inputStream));
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                this.println("Error calculating SHA-256 for " + file.getAbsolutePath());
                if (verbose) {
                    e.printStackTrace(this.getContext().getOutput());
                }
                return null;
            }
        }
        ((InputStream)inputStream).close();
        return string;
    }
}

