/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.preflight.font.descriptor;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;
import org.apache.pdfbox.preflight.PreflightContext;
import org.apache.pdfbox.preflight.ValidationResult;
import org.apache.pdfbox.preflight.font.container.FontContainer;
import org.apache.pdfbox.preflight.font.util.FontMetaDataValidation;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FontDescriptorHelper<T extends FontContainer> {
    protected T fContainer;
    protected PreflightContext context;
    protected PDFont font;
    protected PDFontDescriptorDictionary fontDescriptor;

    public FontDescriptorHelper(PreflightContext context, PDFont font, T fontContainer) {
        this.fContainer = fontContainer;
        this.context = context;
        this.font = font;
    }

    public void validate() {
        PDFontDescriptor fd = this.font.getFontDescriptor();
        if (fd != null && fd instanceof PDFontDescriptorDictionary) {
            this.fontDescriptor = (PDFontDescriptorDictionary)fd;
            if (this.checkMandatoryFields(this.fontDescriptor.getCOSDictionary())) {
                if (this.hasOnlyOneFontFile(this.fontDescriptor)) {
                    PDStream fontFile = this.extractFontFile(this.fontDescriptor);
                    if (fontFile != null) {
                        this.processFontFile(this.fontDescriptor, fontFile);
                        this.checkFontFileMetaData((PDFontDescriptor)this.fontDescriptor, fontFile);
                    }
                } else if (this.fontFileNotEmbedded(this.fontDescriptor)) {
                    ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "FontFile entry is missing from FontDescriptor for " + this.fontDescriptor.getFontName()));
                    ((FontContainer)this.fContainer).notEmbedded();
                } else {
                    ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", "They are more than one FontFile for " + this.fontDescriptor.getFontName()));
                }
            }
        } else {
            ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.2", "FontDescriptor is null or is a AFM Descriptor"));
            ((FontContainer)this.fContainer).notEmbedded();
        }
    }

    protected boolean checkMandatoryFields(COSDictionary fDescriptor) {
        boolean areFieldsPresent = fDescriptor.containsKey("FontName");
        areFieldsPresent &= fDescriptor.containsKey("Flags");
        areFieldsPresent &= fDescriptor.containsKey("ItalicAngle");
        areFieldsPresent &= fDescriptor.containsKey("CapHeight");
        areFieldsPresent &= fDescriptor.containsKey("FontBBox");
        areFieldsPresent &= fDescriptor.containsKey("Ascent");
        areFieldsPresent &= fDescriptor.containsKey("Descent");
        areFieldsPresent &= fDescriptor.containsKey("StemV");
        if (!(areFieldsPresent &= fDescriptor.containsKey(COSName.FONT_NAME))) {
            ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.2", "Some mandatory fields are missing from the FontDescriptor"));
        }
        return areFieldsPresent;
    }

    public abstract PDStream extractFontFile(PDFontDescriptorDictionary var1);

    protected boolean hasOnlyOneFontFile(PDFontDescriptorDictionary fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff2 = fontDescriptor.getFontFile2();
        PDStream ff3 = fontDescriptor.getFontFile3();
        return ff1 != null ^ ff2 != null ^ ff3 != null;
    }

    protected boolean fontFileNotEmbedded(PDFontDescriptorDictionary fontDescriptor) {
        PDStream ff1 = fontDescriptor.getFontFile();
        PDStream ff2 = fontDescriptor.getFontFile2();
        PDStream ff3 = fontDescriptor.getFontFile3();
        return ff1 == null && ff2 == null && ff3 == null;
    }

    protected abstract void processFontFile(PDFontDescriptorDictionary var1, PDStream var2);

    protected void checkFontFileMetaData(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        block6: {
            PDMetadata metadata = null;
            try {
                metadata = fontFile.getMetadata();
                if (metadata == null) break block6;
                byte[] mdAsBytes = this.getMetaDataStreamAsBytes(metadata);
                try {
                    DomXmpParser xmpBuilder = new DomXmpParser();
                    XMPMetadata xmpMeta = xmpBuilder.parse(mdAsBytes);
                    FontMetaDataValidation fontMDval = new FontMetaDataValidation();
                    ArrayList<ValidationResult.ValidationError> ve = new ArrayList<ValidationResult.ValidationError>();
                    fontMDval.analyseFontName(xmpMeta, fontDescriptor, ve);
                    fontMDval.analyseRights(xmpMeta, fontDescriptor, ve);
                    ((FontContainer)this.fContainer).push(ve);
                }
                catch (XmpParsingException e) {
                    if (e.getErrorType() == XmpParsingException.ErrorType.NoValueType) {
                        ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.6", e.getMessage()));
                        break block6;
                    }
                    if (e.getErrorType() == XmpParsingException.ErrorType.XpacketBadEnd) {
                        ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.5", "Unable to parse font metadata due to : " + e.getMessage()));
                        break block6;
                    }
                    ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1", e.getMessage()));
                }
            }
            catch (IllegalStateException e) {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.3", "The Metadata entry doesn't reference a stream object"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] getMetaDataStreamAsBytes(PDMetadata metadata) {
        byte[] result = null;
        ByteArrayOutputStream bos = null;
        InputStream metaDataContent = null;
        try {
            bos = new ByteArrayOutputStream();
            metaDataContent = metadata.createInputStream();
            IOUtils.copyLarge((InputStream)metaDataContent, (OutputStream)bos);
            result = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                ((FontContainer)this.fContainer).push(new ValidationResult.ValidationError("7.1.4", "Unable to read font metadata due to : " + e.getMessage()));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(metaDataContent);
                IOUtils.closeQuietly((OutputStream)bos);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)metaDataContent);
            IOUtils.closeQuietly((OutputStream)bos);
        }
        IOUtils.closeQuietly((InputStream)metaDataContent);
        IOUtils.closeQuietly((OutputStream)bos);
        return result;
    }
}

