/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.logging.tomcat;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class ServerXMLConfigurer {
    private static final String EDIT_TARGET_TAG_QNAME = "Engine";
    private static final EditType EDIT_TARGET_TYPE = EditType.WITHIN_LAST;
    private static final String LISTENER_TAG_QNAME = "Listener";
    private static final String LISTENER_TAG_CLASSNAME_ATTRIBUTE_NAME = "className";
    private static final String LISTENER_TAG_CLASSNAME = "org.apache.portals.applications.logging.tomcat.LoggingPropertiesServerListener";

    public void verifyAndConfigureServerXML(File serverXMLFile) throws Exception {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser = factory.newSAXParser();
        ServerXMLHandler serverXMLHandler = new ServerXMLHandler();
        parser.parse((InputStream)new FileInputStream(serverXMLFile), (DefaultHandler)serverXMLHandler);
        if (serverXMLHandler.isListenerFound()) {
            return;
        }
        if (serverXMLHandler.getEditInsert() == InsertType.ERROR) {
            throw new RuntimeException("Unable to parse or find insertion edit in " + serverXMLFile);
        }
        BufferedReader serverXMLReader = new BufferedReader(new FileReader(serverXMLFile));
        File editServerXMLFile = new File(serverXMLFile.getAbsolutePath() + ".new");
        PrintWriter serverXMLWriter = new PrintWriter(new FileWriter(editServerXMLFile));
        int lineNumber = 1;
        String line = serverXMLReader.readLine();
        while (line != null) {
            if (lineNumber == serverXMLHandler.getEditLine()) {
                String listenerTagComment = "<!-- deployed Apache Portals Jetspeed/APA listener to initialize logging directory system property -->";
                String listenerTag = "<Listener className=\"org.apache.portals.applications.logging.tomcat.LoggingPropertiesServerListener\"/>";
                String indent = serverXMLHandler.getEditIndent();
                switch (serverXMLHandler.getEditInsert()) {
                    case BEFORE: {
                        serverXMLWriter.println(indent + listenerTagComment);
                        serverXMLWriter.println(indent + listenerTag);
                        serverXMLWriter.println(indent);
                        serverXMLWriter.println(line);
                        break;
                    }
                    case BETWEEN: {
                        serverXMLWriter.println(indent + listenerTagComment);
                        serverXMLWriter.println(indent + listenerTag);
                        serverXMLWriter.println(line);
                        break;
                    }
                    case AFTER: {
                        serverXMLWriter.println(line);
                        serverXMLWriter.println(indent);
                        serverXMLWriter.println(indent + listenerTagComment);
                        serverXMLWriter.println(indent + listenerTag);
                        break;
                    }
                    default: {
                        serverXMLWriter.println(line);
                        break;
                    }
                }
            } else {
                serverXMLWriter.println(line);
            }
            ++lineNumber;
            line = serverXMLReader.readLine();
        }
        serverXMLReader.close();
        serverXMLWriter.flush();
        serverXMLWriter.close();
        if (!editServerXMLFile.exists()) {
            throw new RuntimeException("Configured file does not exist: " + editServerXMLFile);
        }
        if (!serverXMLFile.delete()) {
            throw new RuntimeException("Cannot remove file: " + serverXMLFile);
        }
        if (!editServerXMLFile.renameTo(serverXMLFile)) {
            throw new RuntimeException("Cannot move file " + editServerXMLFile + " to: " + serverXMLFile);
        }
    }

    private static class ServerXMLHandler
    extends DefaultHandler {
        private Locator locator;
        private int indentLine = -1;
        private String indent = "";
        private String firstIndent = "";
        private int firstCommentLine = -1;
        private String firstCommentIndent = "";
        private int commentLine = -1;
        private String commentIndent = "";
        private int tagLine = -1;
        private int tagColumn = -1;
        private String tagIndent = "";
        private int previousTagLine = 0;
        private String previousTagIndent = "";
        private boolean tagFound;
        private boolean endTagFound;
        private int editLine = -1;
        private InsertType editInsert = InsertType.ERROR;
        private String editIndent = "";
        private boolean listenerFound;

        private ServerXMLHandler() {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            String className;
            this.updateTagInfo();
            if (qName.equals(ServerXMLConfigurer.EDIT_TARGET_TAG_QNAME)) {
                this.tagFound = true;
                if (this.editLine == -1 && EDIT_TARGET_TYPE == EditType.BEFORE) {
                    this.editLine = this.commentLine != -1 && this.commentLine < this.tagLine && this.tagIndent.equals(this.commentIndent) ? this.commentLine : this.tagLine;
                    this.editInsert = InsertType.BEFORE;
                    this.editIndent = this.tagIndent;
                }
            } else {
                if (this.editLine == -1 && (this.tagFound && EDIT_TARGET_TYPE == EditType.WITHIN_FIRST || this.endTagFound && EDIT_TARGET_TYPE == EditType.AFTER)) {
                    this.editLine = this.firstCommentLine != -1 && this.firstCommentLine < this.tagLine && this.tagIndent.equals(this.firstCommentIndent) ? this.firstCommentLine : this.tagLine;
                    this.editInsert = InsertType.BEFORE;
                    this.editIndent = this.tagIndent;
                }
                this.tagFound = false;
            }
            this.endTagFound = false;
            this.resetCommentInfo();
            if (qName.equals(ServerXMLConfigurer.LISTENER_TAG_QNAME) && (className = attributes.getValue(ServerXMLConfigurer.LISTENER_TAG_CLASSNAME_ATTRIBUTE_NAME)) != null && className.equals(ServerXMLConfigurer.LISTENER_TAG_CLASSNAME)) {
                this.listenerFound = true;
            }
            if (this.firstIndent.length() == 0 && this.tagIndent.length() > 0) {
                this.firstIndent = this.tagIndent;
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.tagLine != this.locator.getLineNumber() || this.tagColumn != this.locator.getColumnNumber()) {
                this.updateTagInfo();
            }
            if (qName.equals(ServerXMLConfigurer.EDIT_TARGET_TAG_QNAME)) {
                if (this.editLine == -1 && this.tagFound && EDIT_TARGET_TYPE == EditType.WITHIN_FIRST) {
                    this.editLine = this.tagLine;
                    this.editInsert = InsertType.BETWEEN;
                    this.editIndent = this.tagIndent + this.firstIndent;
                }
                this.endTagFound = true;
                if (this.editLine == -1 && EDIT_TARGET_TYPE == EditType.WITHIN_LAST) {
                    this.editLine = this.previousTagLine;
                    this.editInsert = InsertType.AFTER;
                    this.editIndent = this.previousTagIndent;
                }
            } else {
                if (this.editLine == -1 && this.endTagFound && EDIT_TARGET_TYPE == EditType.AFTER) {
                    this.editLine = this.previousTagLine;
                    this.editInsert = InsertType.AFTER;
                    this.editIndent = this.previousTagIndent;
                }
                this.endTagFound = false;
            }
            this.tagFound = false;
            this.resetCommentInfo();
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            if (this.firstCommentLine == -1) {
                this.firstCommentLine = this.indentLine;
                this.firstCommentIndent = this.indent;
            }
            this.commentLine = this.indentLine;
            this.commentIndent = this.indent;
            this.indentLine = this.locator.getLineNumber();
            int indentChars = 0;
            for (int i = start + length - 1; i >= start && (chars[i] == ' ' || chars[i] == '\t'); --i) {
                ++indentChars;
            }
            this.indent = new String(chars, start + length - indentChars, indentChars);
        }

        private void updateTagInfo() {
            this.previousTagLine = this.tagLine;
            this.previousTagIndent = this.tagIndent;
            this.tagLine = this.locator.getLineNumber();
            this.tagColumn = this.locator.getColumnNumber();
            this.tagIndent = this.indent;
        }

        private void resetCommentInfo() {
            this.firstCommentLine = -1;
            this.commentLine = -1;
            this.indentLine = -1;
        }

        private int getEditLine() {
            return this.editLine;
        }

        private InsertType getEditInsert() {
            return this.editInsert;
        }

        private String getEditIndent() {
            return this.editIndent;
        }

        private boolean isListenerFound() {
            return this.listenerFound;
        }
    }

    private static enum InsertType {
        BEFORE,
        AFTER,
        BETWEEN,
        ERROR;

    }

    private static enum EditType {
        BEFORE,
        AFTER,
        WITHIN_FIRST,
        WITHIN_LAST;

    }
}

