/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.applications.webcontent2.portlet;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.portals.applications.webcontent2.portlet.history.WebContentPage;
import org.apache.portals.applications.webcontent2.portlet.history.WebContentPageHistory;
import org.apache.portals.applications.webcontent2.portlet.rewriter.MappingRewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.Rewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterController;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RewriterException;
import org.apache.portals.applications.webcontent2.portlet.rewriter.RulesetRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.WebContentRewriter;
import org.apache.portals.applications.webcontent2.portlet.rewriter.html.neko.NekoParserAdaptor;
import org.apache.portals.applications.webcontent2.portlet.rewriter.rules.Ruleset;
import org.apache.portals.applications.webcontent2.portlet.rewriter.xml.SaxParserAdaptor;
import org.apache.portals.bridges.velocity.GenericVelocityPortlet;
import org.apache.portals.messaging.PortletMessaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebContentPortlet
extends GenericVelocityPortlet {
    public static final String VIEW_SOURCE_PARAM = "viewSource";
    public static final String EDIT_SOURCE_PARAM = "editSource";
    public static final String BROWSER_ACTION_PARAM = "wcBrowserAction";
    public static final String BROWSER_ACTION_PREVIOUS_PAGE = "previousPage";
    public static final String BROWSER_ACTION_REFRESH_PAGE = "refreshPage";
    public static final String BROWSER_ACTION_NEXT_PAGE = "nextPage";
    public static final String HISTORY = "webcontent.history";
    public static final String HTTP_STATE = "webcontent.http.state";
    protected static final Logger log = LoggerFactory.getLogger(WebContentPortlet.class);
    public static final String FORM_MULTIPART_METHOD = "multipart";
    public static final String NO_URL = "<p>URL source not specified. Go to edit mode and specify an URL.</p>";
    private RewriterController rewriterController;
    private Ruleset rewriterRuleSet;
    private String defaultProxyHost;
    private int defaultProxyPort = -1;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.defaultProxyHost = StringUtils.trim((String)config.getInitParameter("PROXYHOST"));
        this.defaultProxyPort = NumberUtils.toInt((String)config.getInitParameter("PROXYPORT"), (int)-1);
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException, IOException {
        String browserAction = actionRequest.getParameter(BROWSER_ACTION_PARAM);
        if (browserAction != null) {
            if (!browserAction.equalsIgnoreCase(BROWSER_ACTION_REFRESH_PAGE)) {
                WebContentPageHistory history = (WebContentPageHistory)PortletMessaging.receive((PortletRequest)actionRequest, (String)HISTORY);
                if (browserAction.equalsIgnoreCase(BROWSER_ACTION_PREVIOUS_PAGE)) {
                    if (history.hasPreviousPage()) {
                        history.getPreviousPage();
                    }
                } else if (browserAction.equalsIgnoreCase(BROWSER_ACTION_NEXT_PAGE) && history.hasNextPage()) {
                    history.getNextPage();
                }
            }
            return;
        }
        String webContentURL = actionRequest.getParameter("_AP_URL");
        String webContentMethod = StringUtils.defaultIfEmpty((String)actionRequest.getParameter("_AP_METHOD"), (String)"GET");
        HashMap<String, String[]> webContentParams = new HashMap<String, String[]>(actionRequest.getParameterMap());
        webContentParams.remove("_AP_URL");
        webContentParams.remove("_AP_METHOD");
        if (webContentURL == null || actionRequest.getPortletMode() == PortletMode.EDIT) {
            this.processPreferencesAction(actionRequest, actionResponse);
            webContentURL = actionRequest.getPreferences().getValue("SRC", "http://portals.apache.org");
            webContentParams.clear();
        }
        if (webContentURL != null && webContentURL.length() > 0) {
            WebContentPageHistory history = (WebContentPageHistory)PortletMessaging.receive((PortletRequest)actionRequest, (String)HISTORY);
            if (history == null) {
                history = new WebContentPageHistory();
            }
            history.visitPage(new WebContentPage(webContentURL, webContentMethod, webContentParams));
            PortletMessaging.publish((PortletRequest)actionRequest, (String)HISTORY, (Object)history);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        WebContentPage currentPage;
        String viewPage = (String)request.getAttribute("ViewPage");
        if (viewPage != null) {
            super.doView(request, response);
            return;
        }
        WebContentPageHistory history = (WebContentPageHistory)PortletMessaging.receive((PortletRequest)request, (String)HISTORY);
        if (history == null) {
            history = new WebContentPageHistory();
        }
        if ((currentPage = history.getCurrentPage()) == null) {
            String sourceURL = request.getPreferences().getValue("SRC", "");
            if (sourceURL == null) {
                response.getWriter().print(NO_URL);
                return;
            }
            currentPage = new WebContentPage(sourceURL);
        }
        byte[] content = null;
        response.setContentType("text/html");
        try {
            content = this.doWebContent(currentPage.getMethod(), currentPage.getUrl(), currentPage.getParams(), request, response);
        }
        catch (Throwable t) {
            PrintWriter writer = response.getWriter();
            writer.print("Error retrieveing web content:" + t.getMessage());
            return;
        }
        PrintWriter writer = response.getWriter();
        writer.print("<block>");
        if (history.hasPreviousPage()) {
            PortletURL prevAction = response.createActionURL();
            prevAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_PREVIOUS_PAGE);
            writer.print(" [<a href=\"" + prevAction.toString() + "\">Previous Page</a>] ");
        }
        PortletURL refreshAction = response.createActionURL();
        refreshAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_REFRESH_PAGE);
        writer.print(" [<a href=\"" + refreshAction.toString() + "\">Refresh Page</a>] ");
        if (history.hasNextPage()) {
            PortletURL nextAction = response.createActionURL();
            nextAction.setParameter(BROWSER_ACTION_PARAM, BROWSER_ACTION_NEXT_PAGE);
            writer.print(" [<a href=\"" + nextAction.toString() + "\">Next Page</a>] ");
        }
        writer.print("</block><hr/>");
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(content);
            IOUtils.copy((Reader)new InputStreamReader((InputStream)bais, "UTF-8"), (Writer)writer);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bais);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bais);
        history.visitPage(currentPage);
        PortletMessaging.publish((PortletRequest)request, (String)HISTORY, (Object)history);
    }

    public void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        response.setContentType("text/html");
        this.doPreferencesEdit(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doWebContent(String method, String sourceAttr, Map sourceParams, RenderRequest request, RenderResponse response) throws PortletException {
        CloseableHttpClient httpClient = null;
        HttpRequestBase httpRequest = null;
        try {
            String methodName;
            if (this.rewriterController == null) {
                String webinfDirPath = this.getPortletContext().getRealPath("/WEB-INF") + "/";
                this.rewriterController = this.getRewriterController(webinfDirPath);
            }
            if (this.rewriterRuleSet == null) {
                InputStream is = null;
                try {
                    is = this.getPortletContext().getResourceAsStream("/WEB-INF/conf/default-rewriter-rules.xml");
                    this.rewriterRuleSet = this.rewriterController.loadRuleset(is);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            WebContentRewriter rewriter = (WebContentRewriter)this.createRewriter((PortletRequest)request, this.rewriterController, this.rewriterRuleSet);
            PortletURL action = response.createActionURL();
            rewriter.setActionURL(action);
            URL baseURL = new URL(sourceAttr);
            rewriter.setBaseUrl(baseURL.toString());
            if (baseURL.getProtocol().equals("file")) {
                InputStreamReader reader = new InputStreamReader((InputStream)baseURL.getContent());
                StringWriter writer = new StringWriter();
                rewriter.rewrite(this.rewriterController.createParserAdaptor("text/html"), reader, writer);
                writer.flush();
                byte[] byArray = writer.toString().getBytes();
                return byArray;
            }
            BasicCookieStore cookieStore = new BasicCookieStore();
            httpClient = this.getHttpClient(request, (CookieStore)cookieStore);
            byte[] result = this.doPreemptiveAuthentication(httpClient, (CookieStore)cookieStore, httpRequest = StringUtils.equalsIgnoreCase((String)FORM_MULTIPART_METHOD, (String)(methodName = StringUtils.defaultIfEmpty((String)method, (String)"GET"))) ? this.createHttpRequest(httpClient, methodName, sourceAttr, null, sourceParams, request) : this.createHttpRequest(httpClient, methodName, sourceAttr, sourceParams, null, request), request, response);
            if (result == null) {
                byte[] byArray = this.doHttpWebContent(httpClient, (CookieStore)cookieStore, httpRequest, 0, request, response, rewriter);
                return byArray;
            }
            byte[] byArray = result;
            return byArray;
        }
        catch (PortletException pex) {
            throw pex;
        }
        catch (Exception ex) {
            String msg = "Exception while rewritting HTML content";
            log.error(msg, (Throwable)ex);
            throw new PortletException(msg + ", Error: " + ex.getMessage());
        }
        finally {
            if (httpRequest != null) {
                httpRequest.abort();
            }
            if (httpClient != null) {
                try {
                    httpClient.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] doHttpWebContent(CloseableHttpClient httpClient, CookieStore cookieStore, HttpRequestBase httpRequest, int retryCount, RenderRequest request, RenderResponse response, WebContentRewriter rewriter) throws PortletException {
        byte[] byArray;
        InputStreamReader reader;
        BufferedInputStream bis;
        InputStream is;
        HttpEntity httpEntity;
        CloseableHttpResponse httpResponse;
        block49: {
            byte[] locationHeader22;
            block48: {
                byte[] locationHeader22;
                block47: {
                    byte[] byArray2;
                    block46: {
                        httpResponse = null;
                        httpEntity = null;
                        is = null;
                        bis = null;
                        reader = null;
                        try {
                            HttpClientContext httpClientContext = this.getHttpClientContext((PortletRequest)request, httpRequest);
                            httpResponse = httpClientContext == null ? httpClient.execute((HttpUriRequest)httpRequest) : httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpClientContext);
                            if (rewriter == null) {
                                byte[] byArray3 = null;
                                return byArray3;
                            }
                            rewriter.setBaseUrl(rewriter.getBaseRelativeUrl(httpRequest.getURI().getPath()));
                            ArrayList cookies = cookieStore.getCookies();
                            if (cookies == null) {
                                cookies = new ArrayList();
                            }
                            PortletMessaging.publish((PortletRequest)request, (String)HTTP_STATE, cookies);
                            int responseCode = httpResponse.getStatusLine().getStatusCode();
                            if (responseCode >= 300 && responseCode <= 399) {
                                Header locationHeader22 = httpResponse.getFirstHeader("Location");
                                String redirectLocation = locationHeader22 != null ? locationHeader22.getValue() : null;
                                if (redirectLocation == null) throw new PortletException("Redirection code: " + responseCode + ", but with no redirectionLocation set.");
                                byArray2 = this.doWebContent("GET", redirectLocation, null, request, response);
                                IOUtils.closeQuietly(reader);
                                break block46;
                            }
                            if (responseCode >= 400) {
                                if (responseCode == 401) {
                                    if (retryCount++ >= 1) throw new PortletException("Site requested authorization, but we are unable to provide credentials");
                                    if (!this.doRequestedAuthentication(httpClient, cookieStore, httpRequest, request, response)) throw new PortletException("Site requested authorization, but we are unable to provide credentials");
                                    locationHeader22 = this.doHttpWebContent(httpClient, cookieStore, httpRequest, retryCount, request, response, rewriter);
                                    IOUtils.closeQuietly(reader);
                                    break block47;
                                }
                                if (retryCount++ >= 3) throw new PortletException("Failure reading: " + httpRequest.getURI() + ", response code: " + responseCode);
                                log.info("WebContentPortlet.doHttpWebContent() - retrying: " + httpRequest.getURI() + ", response code: " + responseCode);
                                locationHeader22 = this.doHttpWebContent(httpClient, cookieStore, httpRequest, retryCount, request, response, rewriter);
                                IOUtils.closeQuietly((Reader)reader);
                                break block48;
                            }
                            httpEntity = httpResponse.getEntity();
                            is = httpEntity.getContent();
                            bis = new BufferedInputStream(is);
                            ContentType contentType = ContentType.getOrDefault((HttpEntity)httpEntity);
                            Charset charset = contentType.getCharset();
                            String encoding = StringUtils.defaultIfEmpty((String)(charset != null ? charset.name() : null), (String)"UTF-8");
                            reader = new InputStreamReader((InputStream)bis, encoding);
                            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                            OutputStreamWriter htmlWriter = new OutputStreamWriter((OutputStream)byteOutputStream, encoding);
                            rewriter.rewrite(this.rewriterController.createParserAdaptor("text/html"), reader, htmlWriter);
                            ((Writer)htmlWriter).flush();
                            byArray = byteOutputStream.toByteArray();
                            IOUtils.closeQuietly((Reader)reader);
                            break block49;
                        }
                        catch (UnsupportedEncodingException ueex) {
                            throw new PortletException("Encoding not supported. Error: " + ueex);
                        }
                        catch (RewriterException rwe) {
                            throw new PortletException("Failed to rewrite HTML page. Error: " + rwe);
                        }
                        catch (Exception e) {
                            throw new PortletException("Exception while rewritting HTML page. Error: " + e);
                        }
                    }
                    IOUtils.closeQuietly((InputStream)bis);
                    IOUtils.closeQuietly((InputStream)is);
                    if (httpEntity != null) {
                        try {
                            EntityUtils.consume((HttpEntity)httpEntity);
                        }
                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    if (httpResponse == null) return byArray2;
                    try {
                        httpResponse.close();
                        return byArray2;
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                    return byArray2;
                }
                IOUtils.closeQuietly((InputStream)bis);
                IOUtils.closeQuietly((InputStream)is);
                if (httpEntity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)httpEntity);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                }
                if (httpResponse == null) return locationHeader22;
                try {
                    httpResponse.close();
                    return locationHeader22;
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                return locationHeader22;
            }
            IOUtils.closeQuietly((InputStream)bis);
            IOUtils.closeQuietly((InputStream)is);
            if (httpEntity != null) {
                try {
                    EntityUtils.consume((HttpEntity)httpEntity);
                }
                catch (Exception ignore) {
                    // empty catch block
                }
            }
            if (httpResponse == null) return locationHeader22;
            try {
                httpResponse.close();
                return locationHeader22;
            }
            catch (IOException ignore) {
                // empty catch block
            }
            return locationHeader22;
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        if (httpEntity != null) {
            try {
                EntityUtils.consume((HttpEntity)httpEntity);
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        if (httpResponse == null) return byArray;
        try {
            httpResponse.close();
            return byArray;
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return byArray;
        finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(bis);
            IOUtils.closeQuietly(is);
            if (httpEntity != null) {
                try {
                    EntityUtils.consume(httpEntity);
                }
                catch (Exception ignore) {}
            }
            if (httpResponse != null) {
                try {
                    httpResponse.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected byte[] doPreemptiveAuthentication(CloseableHttpClient client, CookieStore cookieStore, HttpRequestBase httpRequest, RenderRequest request, RenderResponse response) {
        return null;
    }

    protected boolean doRequestedAuthentication(CloseableHttpClient client, CookieStore cookieStore, HttpRequestBase httpRequest, RenderRequest request, RenderResponse response) {
        return false;
    }

    protected RewriterController getRewriterController(String contextPath) throws Exception {
        Class[] rewriterClasses = new Class[]{WebContentRewriter.class, WebContentRewriter.class};
        Class[] adaptorClasses = new Class[]{NekoParserAdaptor.class, SaxParserAdaptor.class};
        MappingRewriterController rewriterController = new MappingRewriterController(contextPath + "conf/rewriter-rules-mapping.xml", Arrays.asList(rewriterClasses), Arrays.asList(adaptorClasses));
        return rewriterController;
    }

    protected Rewriter createRewriter(PortletRequest request, RewriterController rewriterController, Ruleset ruleset) throws RewriterException {
        RulesetRewriter rewriter = rewriterController.createRewriter(ruleset);
        return rewriter;
    }

    protected HttpClientBuilder getHttpClientBuilder(PortletRequest request, CookieStore cookieStore) {
        HttpClientBuilder builder = HttpClients.custom().setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy());
        String proxyHost = StringUtils.trim((String)request.getPreferences().getValue("PROXYHOST", this.defaultProxyHost));
        int proxyPort = NumberUtils.toInt((String)request.getPreferences().getValue("PROXYPORT", Integer.toString(this.defaultProxyPort)), (int)-1);
        if (!StringUtils.isEmpty((String)proxyHost)) {
            if (proxyPort > 0) {
                builder.setProxy(new HttpHost(proxyHost, proxyPort));
            } else {
                builder.setProxy(new HttpHost(proxyHost));
            }
        }
        if (cookieStore != null) {
            List cookies = (List)PortletMessaging.receive((PortletRequest)request, (String)HTTP_STATE);
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    cookieStore.addCookie(cookie);
                }
            }
            builder.setDefaultCookieStore(cookieStore);
        }
        return builder;
    }

    protected CloseableHttpClient getHttpClient(RenderRequest request, CookieStore cookieStore) throws IOException {
        HttpClientBuilder builder = this.getHttpClientBuilder((PortletRequest)request, cookieStore);
        return builder.build();
    }

    protected HttpClientContext getHttpClientContext(PortletRequest request, HttpRequestBase httpRequest) {
        return null;
    }

    protected HttpRequestBase createHttpRequest(CloseableHttpClient client, String method, String uri, Map<String, String[]> queryParams, Map<String, String[]> formPostParams, RenderRequest request) throws IOException, URISyntaxException {
        HttpPost httpRequest = null;
        URIBuilder uriBuilder = new URIBuilder(uri);
        if (queryParams != null) {
            String name = null;
            String[] values = null;
            for (Map.Entry<String, String[]> entry : queryParams.entrySet()) {
                name = entry.getKey();
                values = entry.getValue();
                if (StringUtils.isEmpty((String)name) || values == null) continue;
                for (String value : values) {
                    uriBuilder.addParameter(name, value);
                }
            }
        }
        if (StringUtils.equalsIgnoreCase((String)"POST", (String)method)) {
            httpRequest = new HttpPost(uriBuilder.build());
            if (formPostParams != null) {
                ArrayList<BasicNameValuePair> formParams = new ArrayList<BasicNameValuePair>();
                String name = null;
                String[] values = null;
                for (Map.Entry<String, String[]> entry : formPostParams.entrySet()) {
                    name = entry.getKey();
                    values = entry.getValue();
                    if (StringUtils.isEmpty((String)name) || values == null) continue;
                    for (String value : values) {
                        formParams.add(new BasicNameValuePair(name, value));
                    }
                }
                if (!formParams.isEmpty()) {
                    UrlEncodedFormEntity httpEntity = new UrlEncodedFormEntity(formParams, Consts.UTF_8);
                    httpRequest.setEntity((HttpEntity)httpEntity);
                }
            }
        } else if (StringUtils.equalsIgnoreCase((String)"GET", (String)method) || StringUtils.isBlank((String)method)) {
            httpRequest = new HttpGet(uriBuilder.build());
        }
        String userAgentHeaderValue = request.getProperty("User-Agent");
        httpRequest.setHeader("User-Agent", userAgentHeaderValue);
        return httpRequest;
    }
}

