package org.apache.rya.api;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleStatement;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class RdfCloudTripleStoreStatement extends SimpleStatement {
    private static final long serialVersionUID = 1L;

    private static final ValueFactory VF = SimpleValueFactory.getInstance();

    private Resource[] contexts; //TODO: no blank nodes

    public RdfCloudTripleStoreStatement(Resource subject, IRI predicate, Value object) {
        super(subject, predicate, object);
    }

    public RdfCloudTripleStoreStatement(Resource subject, IRI predicate, Value object,
                                        Resource... contexts) {
        super(subject, predicate, object);
        this.contexts = contexts;
    }

    public Resource[] getContexts() {
        return contexts;
    }

    public Collection<Statement> getStatements() {
        Collection<Statement> statements = new ArrayList<Statement>();

        if (getContexts() != null && getContexts().length > 1) {
            for (Resource contxt : getContexts()) {
                statements.add(VF.createStatement(getSubject(),
                        getPredicate(), getObject(), contxt));
            }
        } else
            statements.add(this);

        return statements;
    }

    @Override
    public Resource getContext() {
        if (contexts == null || contexts.length == 0)
            return null;
        else return contexts[0];
    }
}
