/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.openid.impl;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.auth.core.spi.AbstractAuthenticationFormServlet;
import org.apache.sling.auth.openid.OpenIDFailure;

@Component
@Service(value={Servlet.class})
@Properties(value={@Property(name="service.vendor", value={"The Apache Software Foundation"}), @Property(name="service.description", value={"Default Login Form for OpenID Authentication"})})
public class AuthenticationFormServlet
extends AbstractAuthenticationFormServlet {
    @Property(name="sling.servlet.paths")
    static final String SERVLET_PATH = "/system/sling/openid/login";
    @Property(name="sling.auth.requirements")
    private static final String AUTH_REQUIREMENT = "-/system/sling/openid/login";

    protected String getReason(HttpServletRequest request) {
        String reason = request.getParameter("j_reason");
        if (reason != null) {
            try {
                String idObject;
                OpenIDFailure failure = OpenIDFailure.valueOf(reason);
                if (failure == OpenIDFailure.REPOSITORY && (idObject = request.getParameter("j_openid_identity")) instanceof String) {
                    return "Cannot associate Repository User with OpenID identifier " + idObject;
                }
                return failure.toString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return reason;
            }
        }
        return "";
    }
}

