/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.saml2.impl;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.JackrabbitSession;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.auth.saml2.Saml2User;
import org.apache.sling.auth.saml2.Saml2UserMgtService;
import org.apache.sling.auth.saml2.impl.SimplePrincipal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Saml2UserMgtService.class}, immediate=true)
public class Saml2UserMgtServiceImpl
implements Saml2UserMgtService {
    @Reference
    private ResourceResolverFactory resolverFactory;
    private ResourceResolver resourceResolver;
    private Session session;
    private UserManager userManager;
    private ValueFactory vf;
    private static Logger logger = LoggerFactory.getLogger(Saml2UserMgtServiceImpl.class);
    public static final String SERVICE_NAME = "Saml2UserMgtService";
    public static final String SERVICE_USER = "saml2-user-mgt";

    @Override
    public boolean setUp() {
        try {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("sling.service.subservice", SERVICE_NAME);
            this.resourceResolver = this.resolverFactory.getServiceResourceResolver(param);
            if (Objects.isNull(this.getResourceResolver())) {
                logger.error("Could not setup Saml2UserMgtService. Problem with Service User.");
                return false;
            }
            logger.info(this.resourceResolver.getUserID());
            this.session = (Session)this.resourceResolver.adaptTo(Session.class);
            JackrabbitSession jrSession = (JackrabbitSession)this.session;
            if (Objects.isNull(jrSession)) {
                logger.error("Could not setup Saml2UserMgtService. JackrabbitSession was null.");
                return false;
            }
            this.userManager = jrSession.getUserManager();
            this.vf = this.session.getValueFactory();
            return true;
        }
        catch (LoginException e) {
            logger.error("Could not get SAML2 User Service \r\nCheck mapping org.apache.sling.auth.saml2:{}={}", new Object[]{SERVICE_NAME, SERVICE_USER, e});
        }
        catch (RepositoryException e) {
            logger.error("RepositoryException", (Throwable)e);
        }
        return false;
    }

    ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    void setResolverFactory(ResourceResolverFactory resourceResolverFactory) {
        this.resolverFactory = resourceResolverFactory;
    }

    ResourceResolverFactory getResolverFactory() {
        return this.resolverFactory;
    }

    @Override
    public void cleanUp() {
        this.resourceResolver.close();
        this.session = null;
        this.userManager = null;
        this.vf = null;
    }

    @Override
    public User getOrCreateSamlUser(Saml2User user) {
        try {
            Authorizable authorizable = this.userManager.getAuthorizable(user.getId());
            User jackrabbitUser = (User)authorizable;
            if (jackrabbitUser != null) {
                return jackrabbitUser;
            }
            jackrabbitUser = this.userManager.createUser(user.getId(), null);
            this.session.save();
            return jackrabbitUser;
        }
        catch (RepositoryException e) {
            logger.error("Could not get User", (Throwable)e);
            return null;
        }
    }

    @Override
    public User getOrCreateSamlUser(Saml2User user, String userHome) {
        try {
            Authorizable authorizable = this.userManager.getAuthorizable(user.getId());
            User jackrabbitUser = (User)authorizable;
            if (jackrabbitUser != null) {
                return jackrabbitUser;
            }
            SimplePrincipal principal = new SimplePrincipal(user.getId());
            jackrabbitUser = this.userManager.createUser(user.getId(), null, (Principal)principal, userHome);
            this.session.save();
            return jackrabbitUser;
        }
        catch (RepositoryException e) {
            logger.error("Could not get User", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean updateGroupMembership(Saml2User user) {
        try {
            User jrcUser = (User)this.userManager.getAuthorizable(user.getId());
            Iterator allGroups = this.userManager.findAuthorizables("jcr:primaryType", "rep:Group");
            while (allGroups.hasNext()) {
                Group managedGroup = (Group)allGroups.next();
                Value[] valueList = managedGroup.getProperty("managedGroup");
                if (valueList == null && user.getGroupMembership().contains(managedGroup.getID())) {
                    managedGroup.setProperty("managedGroup", this.vf.createValue(true));
                    managedGroup.addMember((Authorizable)jrcUser);
                    continue;
                }
                if (valueList == null || valueList.length <= 0 || !valueList[0].getBoolean()) continue;
                if (user.getGroupMembership().contains(managedGroup.getID())) {
                    managedGroup.addMember((Authorizable)jrcUser);
                    continue;
                }
                managedGroup.removeMember((Authorizable)jrcUser);
            }
            this.session.save();
            return true;
        }
        catch (RepositoryException e) {
            logger.error("RepositoryException", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean updateUserProperties(Saml2User user) {
        try {
            User jcrUser = (User)this.userManager.getAuthorizable(user.getId());
            for (Map.Entry<String, String> entry : user.getUserProperties().entrySet()) {
                jcrUser.setProperty(entry.getKey(), this.vf.createValue(entry.getValue()));
            }
            this.session.save();
            return true;
        }
        catch (RepositoryException e) {
            logger.error("User Properties could not synchronize", (Throwable)e);
            return false;
        }
    }
}

