/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.base.shared;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class LauncherClassLoader
extends URLClassLoader {
    private final Set<String> launcherPackages;

    LauncherClassLoader(File launcherJar, File[] extJars) throws MalformedURLException {
        super(new URL[]{launcherJar.toURI().toURL()}, LauncherClassLoader.class.getClassLoader());
        HashSet<String> collectedPackages = new HashSet<String>();
        this.processJarPackages(launcherJar, collectedPackages);
        List<File> extJarFileList = this.getExtJarFileList(extJars);
        for (File extJarFile : extJarFileList) {
            this.addURL(extJarFile.toURI().toURL());
            this.processJarPackages(extJarFile, collectedPackages);
        }
        this.launcherPackages = collectedPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJarPackages(File jarFile, Set<String> packageSet) {
        JarFile jar = null;
        try {
            jar = new JarFile(jarFile, false);
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                String packageName;
                String entryName = entries.nextElement().getName();
                if (!entryName.endsWith(".class") || entryName.startsWith("META-INF/") || entryName.startsWith("javax/") || (packageName = this.getPackageName(entryName, 47)) == null || !packageSet.add(packageName)) continue;
                packageSet.add(packageName.replace('/', '.'));
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private List<File> getExtJarFileList(File[] extJars) throws MalformedURLException {
        ArrayList<File> jarList = new ArrayList<File>();
        for (File extJarFile : extJars) {
            if (extJarFile == null || !extJarFile.exists()) continue;
            jarList.add(extJarFile);
        }
        return jarList;
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.containsPackage(name, 46)) {
                c = this.findClass(name);
            } else {
                return super.loadClass(name, resolve);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    @Override
    public URL getResource(String name) {
        if (this.containsPackage(name, 47)) {
            return this.findResource(name);
        }
        return super.getResource(name);
    }

    private String getPackageName(String name, int separator) {
        int speIdx = name.lastIndexOf(separator);
        return speIdx > 0 ? name.substring(0, speIdx) : null;
    }

    private boolean containsPackage(String name, int separator) {
        String packageName = this.getPackageName(name, separator);
        return packageName == null ? false : this.launcherPackages.contains(packageName);
    }
}

