/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.handler.media.format.impl;

import com.google.common.collect.ImmutableSet;
import io.wcm.handler.media.format.MediaFormat;
import io.wcm.handler.media.format.MediaFormatHandler;
import io.wcm.wcm.commons.contenttype.ContentType;
import java.io.IOException;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, immediate=true, property={"sling.servlet.extensions=json", "sling.servlet.selectors=wcmio_handler_media_mediaformat_list", "sling.servlet.resourceTypes=sling/servlet/default", "sling.servlet.methods=GET"})
public final class DefaultMediaFormatListProvider
extends SlingSafeMethodsServlet {
    private static final long serialVersionUID = 1L;

    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            Set<MediaFormat> mediaFormats = this.getMediaFormats(request);
            response.setContentType(ContentType.JSON);
            JSONArray mediaFormatList = new JSONArray();
            if (mediaFormats != null) {
                for (MediaFormat mediaFormat : mediaFormats) {
                    if (mediaFormat.isInternal()) continue;
                    JSONObject mediaFormatItem = new JSONObject();
                    mediaFormatItem.put("name", (Object)mediaFormat.getName());
                    mediaFormatItem.put("text", (Object)mediaFormat.toString());
                    mediaFormatItem.put("width", mediaFormat.getWidth());
                    mediaFormatItem.put("height", mediaFormat.getHeight());
                    mediaFormatItem.put("widthMin", mediaFormat.getMinWidth());
                    mediaFormatItem.put("heightMin", mediaFormat.getMinHeight());
                    mediaFormatItem.put("isImage", mediaFormat.isImage());
                    mediaFormatItem.put("ratio", mediaFormat.getRatio());
                    mediaFormatItem.put("ratioWidth", mediaFormat.getRatioWidthAsDouble());
                    mediaFormatItem.put("ratioHeight", mediaFormat.getRatioHeightAsDouble());
                    mediaFormatItem.put("ratioDisplayString", (Object)mediaFormat.getRatioDisplayString());
                    mediaFormatList.put((Object)mediaFormatItem);
                }
            }
            response.getWriter().write(mediaFormatList.toString());
        }
        catch (JSONException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    protected Set<MediaFormat> getMediaFormats(SlingHttpServletRequest request) {
        MediaFormatHandler mediaFormatHandler = (MediaFormatHandler)request.adaptTo(MediaFormatHandler.class);
        if (mediaFormatHandler != null) {
            return mediaFormatHandler.getMediaFormats();
        }
        return ImmutableSet.of();
    }
}

