/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.factories.configuration.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Coordinator {
    public static final Coordinator SHARED = new Coordinator();
    private static final long EXPIRY = 5000L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<Operation> operations = new ArrayList<Operation>();

    private Coordinator() {
    }

    public void add(Operation op) {
        this.cleanup();
        this.operations.add(op);
        this.logger.debug("Adding {}", (Object)op);
    }

    public Operation get(String pid, String factoryPid, boolean isDelete) {
        this.cleanup();
        this.logger.debug("Searching {} : {} - {}", new Object[]{pid, factoryPid, isDelete});
        Operation result = null;
        Iterator<Operation> i = this.operations.iterator();
        while (i.hasNext()) {
            Operation op = i.next();
            if (op.isDelete != isDelete || !op.pid.equals(pid) || (op.factoryPid != null || factoryPid != null) && (op.factoryPid == null || !op.factoryPid.equals(factoryPid))) continue;
            result = op;
            i.remove();
            break;
        }
        this.logger.debug("Result ({} : {} - {}) : {}", new Object[]{pid, factoryPid, isDelete, result});
        return result;
    }

    private void cleanup() {
        long time = System.currentTimeMillis() - 5000L;
        Iterator<Operation> i = this.operations.iterator();
        while (i.hasNext()) {
            Operation op = i.next();
            if (op.created > time) break;
            this.logger.debug("Deleting expired {}", (Object)op);
            i.remove();
        }
    }

    public static final class Operation {
        public final String pid;
        public final String factoryPid;
        public final boolean isDelete;
        public final long created = System.currentTimeMillis();

        public Operation(String pid, String factoryPid, boolean isDelete) {
            this.pid = pid;
            this.factoryPid = factoryPid;
            this.isDelete = isDelete;
        }

        public String toString() {
            return "Operation [pid=" + this.pid + ", factoryPid=" + this.factoryPid + ", isDelete=" + this.isDelete + ", created=" + this.created + "]";
        }
    }
}

