/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.sling.jcr.repoinit.it;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;

import static org.junit.Assert.assertTrue;
import static org.ops4j.pax.exam.cm.ConfigurationAdminOptions.newConfiguration;

/** Verify that statements provided as URLS to our RepositoryInitializer
 *  are executed.
 */
@RunWith(PaxExam.class)
@ExamReactorStrategy(PerClass.class)
public class RepositoryInitializerIT extends RepoInitTestSupport {

    @Override
    protected Option[] additionalOptions() {
        final String[] srcUrls = {
            "raw:" + getTestFileUrl("/repoinit-path-1.txt"), "raw:" + getTestFileUrl("/repoinit-path-2.txt")
        };

        return new Option[] {
            newConfiguration("org.apache.sling.jcr.repoinit.impl.RepositoryInitializer")
                    .put("references", srcUrls)
                    .asOption()
        };
    }

    @Test
    public void path1Created() throws Exception {
        assertTrue(session.itemExists("/repoinit-test/path-1"));
    }

    @Test
    public void path2Created() throws Exception {
        assertTrue(session.itemExists("/repoinit-test/path-2"));
    }
}
