/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.performance;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;

public class PerformanceRecord {
    private final DescriptiveStatistics statistics;
    private final Number threshold;

    public PerformanceRecord(DescriptiveStatistics statistics, Number threshold) {
        this.statistics = statistics;
        this.threshold = threshold;
    }

    public DescriptiveStatistics getStatistics() {
        return this.statistics;
    }

    public Number getThreshold() {
        return this.threshold;
    }

    public String checkThreshold(DescriptiveStatistics reference) {
        if (this.threshold == null || this.threshold.doubleValue() <= 0.0) {
            return null;
        }
        double ratio = this.statistics.getPercentile(50.0) / reference.getPercentile(50.0);
        if (ratio > this.threshold.doubleValue()) {
            return String.format("Threshold exceeded! Expected <%6.2f, actual %6.2f", this.threshold.doubleValue(), ratio);
        }
        return null;
    }
}

