/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.scripting.bundle.tracker.internal.Executable;
import org.apache.sling.scripting.bundle.tracker.internal.JavaEscapeUtils;
import org.apache.sling.scripting.bundle.tracker.internal.PrecompiledScript;
import org.apache.sling.scripting.bundle.tracker.internal.Script;
import org.apache.sling.scripting.bundle.tracker.internal.TypeProvider;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BundledScriptFinder.class})
public class BundledScriptFinder {
    private static final String NS_JAVAX_SCRIPT_CAPABILITY = "javax.script";
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final Set<String> DEFAULT_METHODS = new HashSet<String>(Arrays.asList("GET", "HEAD"));
    @Reference
    private ScriptEngineManager scriptEngineManager;

    Executable getScript(SlingHttpServletRequest request, LinkedHashSet<TypeProvider> typeProviders, boolean precompiledScripts) {
        for (TypeProvider provider : typeProviders) {
            List<String> scriptMatches = this.buildScriptMatches(request, provider.getType());
            for (String match : scriptMatches) {
                for (String extension : this.getScriptEngineExtensions()) {
                    if (precompiledScripts) {
                        String className = this.fromScriptPathToClassName(match);
                        try {
                            Class clazz = provider.getBundle().loadClass(className);
                            return new PrecompiledScript(provider.getBundle(), this.scriptEngineManager.getEngineByExtension(extension), clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                        }
                        catch (ClassNotFoundException clazz) {
                            continue;
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot correctly instantiate class " + className + DOT);
                        }
                    }
                    URL bundledScriptURL = provider.getBundle().getEntry("javax.script/" + match + DOT + extension);
                    if (bundledScriptURL == null) continue;
                    return new Script(provider.getBundle(), bundledScriptURL, this.scriptEngineManager.getEngineByExtension(extension));
                }
            }
        }
        return null;
    }

    private List<String> buildScriptMatches(SlingHttpServletRequest request, String providerType) {
        ArrayList<String> matches = new ArrayList<String>();
        String resourceType = providerType;
        String version = null;
        String method = request.getMethod();
        boolean defaultMethod = DEFAULT_METHODS.contains(method);
        if (resourceType.contains(SLASH) && StringUtils.countMatches((CharSequence)resourceType, (CharSequence)SLASH) == 1) {
            version = resourceType.substring(resourceType.indexOf(SLASH) + 1);
            resourceType = resourceType.substring(0, resourceType.length() - version.length() - 1);
        }
        String extension = request.getRequestPathInfo().getExtension();
        String[] selectors = request.getRequestPathInfo().getSelectors();
        if (selectors.length > 0) {
            for (int i = selectors.length - 1; i >= 0; --i) {
                String scriptForMethod = resourceType + (StringUtils.isNotEmpty((CharSequence)version) ? SLASH + version + SLASH : SLASH) + method + DOT + String.join((CharSequence)SLASH, Arrays.copyOf(selectors, i + 1));
                String scriptNoMethod = resourceType + (StringUtils.isNotEmpty((CharSequence)version) ? SLASH + version + SLASH : SLASH) + String.join((CharSequence)SLASH, Arrays.copyOf(selectors, i + 1));
                if (StringUtils.isNotEmpty((CharSequence)extension)) {
                    if (defaultMethod) {
                        matches.add(scriptNoMethod + DOT + extension);
                    }
                    matches.add(scriptForMethod + DOT + extension);
                }
                if (defaultMethod) {
                    matches.add(scriptNoMethod);
                }
                matches.add(scriptForMethod);
            }
        }
        String scriptForMethod = resourceType + (StringUtils.isNotEmpty((CharSequence)version) ? SLASH + version + SLASH : SLASH) + method;
        String scriptNoMethod = resourceType + (StringUtils.isNotEmpty((CharSequence)version) ? SLASH + version + SLASH : SLASH) + resourceType.substring(resourceType.lastIndexOf(DOT) + 1);
        if (StringUtils.isNotEmpty((CharSequence)extension)) {
            if (defaultMethod) {
                matches.add(scriptNoMethod + DOT + extension);
            }
            matches.add(scriptForMethod + DOT + extension);
        }
        if (defaultMethod) {
            matches.add(scriptNoMethod);
        }
        matches.add(scriptForMethod);
        return Collections.unmodifiableList(matches);
    }

    private List<String> getScriptEngineExtensions() {
        ArrayList<String> _scriptEngineExtensions = new ArrayList<String>();
        for (ScriptEngineFactory factory : this.scriptEngineManager.getEngineFactories()) {
            _scriptEngineExtensions.addAll(factory.getExtensions());
        }
        Collections.reverse(_scriptEngineExtensions);
        return Collections.unmodifiableList(_scriptEngineExtensions);
    }

    private String fromScriptPathToClassName(String scriptPath) {
        String[] parts = scriptPath.split(SLASH);
        StringBuilder stringBuilder = new StringBuilder();
        for (String part : parts) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(DOT);
            }
            stringBuilder.append(JavaEscapeUtils.makeJavaIdentifier(part));
        }
        return stringBuilder.toString();
    }
}

